/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.config.provider;

import com.bes.enterprise.appserver.common.util.CommonUtils;
import com.bes.enterprise.config.miniparser.ConfigBindingException;
import com.bes.enterprise.config.miniparser.DomParserContext;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.miniparser.DomTemplateParser;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ConfigProviderHelper {
    public static DomTemplate parse(String configContent) {
        if (ConfigProviderHelper.isJsonConfig(configContent)) {
            return ConfigProviderHelper.parseJsonConfig(configContent);
        }
        return ConfigProviderHelper.parseXmlConfig(configContent);
    }

    private static DomTemplate parseXmlConfig(String configContent) {
        XMLStreamReader reader = null;
        try {
            DomTemplate domTemplate;
            StringReader sReader = new StringReader(configContent);
            reader = CommonUtils.newXMLInputFactory().createXMLStreamReader(sReader);
            DomParserContext parseContext = ConfigProviderHelper.getServerConfigParserContext();
            DomTemplateParser parser = new DomTemplateParser();
            DomTemplate domTemplate2 = domTemplate = parser.parse(reader, parseContext);
            return domTemplate2;
        }
        catch (XMLStreamException ex) {
            throw new ConfigBindingException("Failure to parse config file!", ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static DomTemplate parseJsonConfig(String configContent) {
        ClassLoader loader = ConfigProviderHelper.class.getClassLoader();
        Class<?> jsonHelperClass = null;
        try {
            jsonHelperClass = loader.loadClass("com.bes.enterprise.config.json.DomTemplateJsonHelper");
        }
        catch (ClassNotFoundException cfEx) {
            loader = Thread.currentThread().getContextClassLoader();
            try {
                jsonHelperClass = loader.loadClass("com.bes.enterprise.config.json.DomTemplateJsonHelper");
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigBindingException("Json formed config not support yet!");
            }
        }
        try {
            Method method = jsonHelperClass.getDeclaredMethod("fromJson", String.class, String.class, DomParserContext.class);
            DomParserContext parseContext = ConfigProviderHelper.getServerConfigParserContext();
            DomTemplate domTemplate = (DomTemplate)method.invoke(null, configContent, "server", parseContext);
            return domTemplate;
        }
        catch (NoSuchMethodException nmEx) {
            throw new ConfigBindingException("Json formed config not support yet!");
        }
        catch (IllegalAccessException illEx) {
            throw new ConfigBindingException("Failure to parse json formed config!", illEx);
        }
        catch (InvocationTargetException invEx) {
            Throwable cause = invEx.getTargetException();
            if (cause instanceof ConfigBindingException) {
                throw (ConfigBindingException)cause;
            }
            throw new ConfigBindingException("Failure to parse json formed config!", cause);
        }
    }

    public static boolean isJsonConfig(String content) {
        char c2;
        int i2;
        int length = content.length();
        for (i2 = 0; i2 < length; ++i2) {
            c2 = content.charAt(i2);
            if (' ' == c2) continue;
            if ('{' == c2) break;
            return false;
        }
        for (i2 = length - 1; i2 > 0; --i2) {
            c2 = content.charAt(i2);
            if (' ' == c2) continue;
            if ('}' == c2) break;
            return false;
        }
        return true;
    }

    public static DomParserContext getServerConfigParserContext() {
        DomParserContext parserContext = new DomParserContext();
        parserContext.addDomTemplateHandlers(new DomParserContext.PasswordEncryptedHandler());
        parserContext.addAttributeConfig("server", new DomParserContext.AttributeConfig().name("log-version").defaultValue("true")).addAttributeConfig("server", new DomParserContext.AttributeConfig().name("memory-leak-prevention").defaultValue("true")).addAttributeConfig("server", new DomParserContext.AttributeConfig().name("threadlocal-leak-prevention").defaultValue("true")).addAttributeConfig("server", new DomParserContext.AttributeConfig().name("adminhost").defaultValue("127.0.0.1")).addAttributeConfig("server", new DomParserContext.AttributeConfig().name("adminport").defaultValue("-1")).addAttributeConfig("server", new DomParserContext.AttributeConfig().name("stop").defaultValue("stop"));
        parserContext.addAttributeConfig("server/security-service", new DomParserContext.AttributeConfig().name("lock-enabled").defaultValue("false"));
        parserContext.addAttributeConfig("server/security-service", new DomParserContext.AttributeConfig().name("default-realm").required(true));
        parserContext.addAttributeConfig("server/security-service/auth-realm", new DomParserContext.AttributeConfig().name("class-name").required(true));
        parserContext.addAttributeConfig("server/security-service/auth-realm/auth-realm", new DomParserContext.AttributeConfig().name("class-name").required(true));
        parserContext.addAttributeConfig("server/security-service/auth-realm/credential-handler", new DomParserContext.AttributeConfig().name("class-name").defaultValue("com.bes.enterprise.webtier.realm.MessageDigestCredentialHandler"));
        parserContext.addAttributeConfig("server/system-property", new DomParserContext.AttributeConfig().name("name").required(true));
        parserContext.addAttributeConfig("server/web-container", new DomParserContext.AttributeConfig().name("default-virtual-server").defaultValue("server"));
        parserContext.addAttributeConfig("server/web-container/http-service", new DomParserContext.AttributeConfig().name("global-access-log-enabled").defaultValue("false"));
        parserContext.addAttributeConfig("server/web-container/http-service/access-log", new DomParserContext.AttributeConfig().name("format").defaultValue("%h %l %u %t \"%r\" %s %b %D")).addAttributeConfig("server/web-container/http-service/access-log", new DomParserContext.AttributeConfig().name("rotation-enabled").defaultValue("true"));
        parserContext.addAttributeConfig("server/web-container/http-service/jar-scanner", new DomParserContext.AttributeConfig().name("class-name").defaultValue("com.bes.enterprise.web.util.scan.StandardJarScanner"));
        parserContext.addAttributeConfig("server/web-container/http-service/http-file", new DomParserContext.AttributeConfig().name("allow-linking").defaultValue("false")).addAttributeConfig("server/web-container/http-service/http-file", new DomParserContext.AttributeConfig().name("cache-max-size").defaultValue("262144")).addAttributeConfig("server/web-container/http-service/http-file", new DomParserContext.AttributeConfig().name("caching-allowed").defaultValue("true")).addAttributeConfig("server/web-container/http-service/http-file", new DomParserContext.AttributeConfig().name("cache-ttl").defaultValue("5000"));
        parserContext.addAttributeConfig("server/web-container/http-service/jar-scanner/jar-scan-filter", new DomParserContext.AttributeConfig().name("class-name").defaultValue("com.bes.enterprise.web.util.scan.StandardJarScanFilter"));
        parserContext.addAttributeConfig("server/thread-pools/thread-pool", new DomParserContext.AttributeConfig().name("class-name").defaultValue("com.bes.enterprise.webtier.core.WorkThreadExecutor"));
        parserContext.addAttributeConfig("server/web-container/session-managers/session-manager", new DomParserContext.AttributeConfig().name("class-name").defaultValue("com.bes.enterprise.webtier.session.DefaultManager"));
        parserContext.addAttributeConfig("server/web-container/session-managers/session-manager/store", new DomParserContext.AttributeConfig().name("class-name").defaultValue("com.bes.enterprise.webtier.session.FileStore"));
        parserContext.addAttributeConfig("server/web-container/session-managers/session-manager/session-id-generator", new DomParserContext.AttributeConfig().name("class-name").defaultValue("com.bes.enterprise.webtier.util.DefaultSessionIdGenerator"));
        parserContext.addAttributeConfig("server/web-container/session-config/cookie-processor", new DomParserContext.AttributeConfig().name("class-name").defaultValue("com.bes.enterprise.web.util.http.Rfc6265CookieProcessor")).addAttributeConfig("server/web-container/session-config/cookie-processor", new DomParserContext.AttributeConfig().name("allow-equals-in-value").defaultValue("false")).addAttributeConfig("server/web-container/session-config/cookie-processor", new DomParserContext.AttributeConfig().name("allow-http-seps-in-v0").defaultValue("false")).addAttributeConfig("server/web-container/session-config/cookie-processor", new DomParserContext.AttributeConfig().name("allow-name-only").defaultValue("false")).addAttributeConfig("server/web-container/session-config/cookie-processor", new DomParserContext.AttributeConfig().name("always-add-expires").defaultValue("true")).addAttributeConfig("server/web-container/session-config/cookie-processor", new DomParserContext.AttributeConfig().name("forward-slash-is-separator").defaultValue("false"));
        parserContext.addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("enabled").defaultValue("true")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("security-enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("io-mode").defaultValue("NIO")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("gmssl-enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("http2-enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("address").defaultValue("0.0.0.0")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("use-ip-vhosts").defaultValue("false")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("accept-count").defaultValue("4096")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("acceptor-thread").defaultValue("1")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("acceptor-thread-priority").defaultValue("5")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("bind-on-init").defaultValue("true")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("connection-linger").defaultValue("-1")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("connection-timeout").defaultValue("60000")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("max-connections").defaultValue("10000")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("processor-cache").defaultValue("200")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("socket-buffer").defaultValue("9000")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("tcp-no-delay").defaultValue("true")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("thread-priority").defaultValue("5")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("upgrade-async-write-buffer-size").defaultValue("8192")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("app-read-buf-size").defaultValue("8192")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("app-write-buf-size").defaultValue("8192")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("default-virtual-server").defaultValue("server"));
        parserContext.addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("thread-pool").required(true)).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("port").required(true));
        parserContext.addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("allow-trace").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("async-timeout").defaultValue("30000")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("dns-lookup-enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("max-parameter-count").defaultValue("10000")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("max-post-size").defaultValue("2097152")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("xpowered-by").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("uri-encoding").defaultValue("UTF-8")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("compressible-mime-type").defaultValue("text/html,text/xml,text/plain,text/css,text/javascript,application/javascript")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("compression").defaultValue("off")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("compression-min-size").defaultValue("2048")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("no-compression-user-agents").defaultValue("")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("connection-upload-timeout").defaultValue("300000")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("disable-upload-timeout").defaultValue("true")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("restricted-user-agents").defaultValue("")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("use-keep-alive-response-header").defaultValue("false"));
        parserContext.addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("class-name").defaultValue("com.bes.enterprise.web.crane.http2.Http2Protocol")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("compressible-mime-type").defaultValue("text/html,text/xml,text/plain,text/css,text/javascript,application/javascript")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("compression").defaultValue("off")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("compression-min-size").defaultValue("2048")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("initial-window-size").defaultValue("65535")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("max-concurrent-stream-execution").defaultValue("200")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("max-concurrent-stream").defaultValue("200")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("max-header-count").defaultValue("100")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("max-header-size").defaultValue("8192")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("max-trailer-count").defaultValue("100")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("max-trailer-size").defaultValue("8192")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("no-compression-user-agents").defaultValue("")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("read-timeout").defaultValue("10000")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("write-timeout").defaultValue("10000")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("keep-alive-timeout").defaultValue("-1"));
        parserContext.addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("keystore-file").defaultValue("${com.bes.instanceRoot}/conf/security/keystore.jks")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("truststore-file").defaultValue("${com.bes.instanceRoot}/conf/security/cacerts.jks")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("keystore-type").defaultValue("JKS")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("keystore-pass").defaultValue("changeit")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("truststore-type").defaultValue("JKS")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("cert-type").defaultValue("CER")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("truststore-pass").defaultValue("changeit")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("key-alias").defaultValue("bes")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("key-pass").defaultValue("changeit")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("client-auth").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("ssl-protocol").defaultValue("TLS")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("ssl3-enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("tls-enabled").defaultValue("true")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("tls11-enabled").defaultValue("true")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("tls12-enabled").defaultValue("true")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("tls13-enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("ciphers").defaultValue("HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5"));
        parserContext.addAttributeConfig("server/web-container/http-listener/gmssl", new DomParserContext.AttributeConfig().name("keystore-file").defaultValue("${com.bes.instanceRoot}/conf/security/keystore.bks")).addAttributeConfig("server/web-container/http-listener/gmssl", new DomParserContext.AttributeConfig().name("keystore-pass").defaultValue("changeit")).addAttributeConfig("server/web-container/http-listener/gmssl", new DomParserContext.AttributeConfig().name("key-alias").defaultValue("bes")).addAttributeConfig("server/web-container/http-listener/gmssl", new DomParserContext.AttributeConfig().name("key-pass").defaultValue("changeit"));
        parserContext.addAttributeConfig("server/web-container/http-listener/keep-alive", new DomParserContext.AttributeConfig().name("keep-alive-timeout").defaultValue("60")).addAttributeConfig("server/web-container/http-listener/keep-alive", new DomParserContext.AttributeConfig().name("max-keep-alive-requests").defaultValue("1024"));
        parserContext.addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("app-base").defaultValue("hotdeploy")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("error-report-valve-class").defaultValue("com.bes.enterprise.webtier.valves.ErrorReportValve")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("state").defaultValue("on")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("state").defaultValue("on")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("create-dirs").defaultValue("true")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("auto-deploy").defaultValue("true")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("background-processor-delay").defaultValue("-1")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("deploy-on-startup").defaultValue("true")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("fail-ctx-if-servlet-start-fails").defaultValue("false")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("start-stop-threads").defaultValue("1")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("undeploy-old-versions").defaultValue("false")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("copy-xml").defaultValue("false")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("unpack-wars").defaultValue("true")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("stuck-thread-max-time").defaultValue("0")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("stuck-thread-timer-interval").defaultValue("10"));
        parserContext.addAttributeConfig("server/hotdeploy-config", new DomParserContext.AttributeConfig().name("enabled").defaultValue("true")).addAttributeConfig("server/hotdeploy-config", new DomParserContext.AttributeConfig().name("check-interval").defaultValue("3")).addAttributeConfig("server/hotdeploy-config", new DomParserContext.AttributeConfig().name("virtual-server").defaultValue("server")).addAttributeConfig("server/hotdeploy-config", new DomParserContext.AttributeConfig().name("enabled").defaultValue("true")).addAttributeConfig("server/hotdeploy-config", new DomParserContext.AttributeConfig().name("status-file-creatable").defaultValue("false")).addAttributeConfig("server/hotdeploy-config", new DomParserContext.AttributeConfig().name("directory").defaultValue("${com.bes.instanceRoot}/hotdeploy"));
        parserContext.addAttributeConfig("server/jmx-connector", new DomParserContext.AttributeConfig().name("enabled").defaultValue("true")).addAttributeConfig("server/jmx-connector", new DomParserContext.AttributeConfig().name("address").defaultValue("0.0.0.0")).addAttributeConfig("server/jmx-connector", new DomParserContext.AttributeConfig().name("security-enabled").defaultValue("false"));
        parserContext.addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("keystore-file").defaultValue("${com.bes.instanceRoot}/conf/security/keystore.jks")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("truststore-file").defaultValue("${com.bes.instanceRoot}/conf/security/cacerts.jks")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("keystore-type").defaultValue("JKS")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("keystore-pass").defaultValue("changeit")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("truststore-type").defaultValue("JKS")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("truststore-pass").defaultValue("changeit")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("key-alias").defaultValue("bes")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("key-pass").defaultValue("changeit")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("client-auth").defaultValue("false")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("ssl-protocol").defaultValue("TLS")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("ssl3-enabled").defaultValue("false")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("tls-enabled").defaultValue("true")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("tls11-enabled").defaultValue("true")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("tls12-enabled").defaultValue("true")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("tls13-enabled").defaultValue("false")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("ciphers").defaultValue("HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5"));
        parserContext.addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("enabled").defaultValue("true")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("jta-managed").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("driver-class-path")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("initial-pool-size").defaultValue("8")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("min-idle").defaultValue("8")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("max-pool-size").defaultValue("32")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("max-wait-time-in-millis").defaultValue("60000")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("validation-query")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("validation-query-timeout").defaultValue("0")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("test-on-borrow").defaultValue("true")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("test-while-idle").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("time-between-eviction-runs-millis")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("num-tests-per-eviction-run")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("idle-timeout").defaultValue("300")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("max-evictable-idle-timeout").defaultValue("-1")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("pool-prepared-statements").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("statement-cache-size").defaultValue("10")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("statement-timeout-in-seconds").defaultValue("-1")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("fetch-size").defaultValue("0")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("fail-all-connection").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("max-connection-age").defaultValue("0")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("isolation-level")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("access-to-underlying-connection-allowed").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("connection-leak-timeout-in-seconds").defaultValue("0")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("validate-atmost-once-period-in-seconds").defaultValue("120")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("enable-leakage-recovery").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("log-abandoned").defaultValue("true")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("rollback-on-return").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("enable-auto-commit-on-return").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("pool-statements").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("default-catalog")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("sql-trace").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("max-queries").defaultValue("1000")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("log-slow").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("log-failed").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("using-trace").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("connection-init-sqls")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("enable-sharing-resources").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("fairness").defaultValue("false"));
        parserContext.addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("driver-class-name").required(true)).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("resource-type").required(true)).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("url").required(true)).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("username").required(true)).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("password").required(true));
        parserContext.addAttributeConfig("server/log-service", new DomParserContext.AttributeConfig().name("log-file").defaultValue("${com.bes.instanceRoot}/logs/server.log")).addAttributeConfig("server/log-service", new DomParserContext.AttributeConfig().name("rotation-enabled").defaultValue("false")).addAttributeConfig("server/log-service", new DomParserContext.AttributeConfig().name("rotation-time").defaultValue("0")).addAttributeConfig("server/log-service", new DomParserContext.AttributeConfig().name("rotation-size").defaultValue("104857600")).addAttributeConfig("server/log-service", new DomParserContext.AttributeConfig().name("max-history-files").defaultValue("10"));
        parserContext.addAttributeConfig("server/log-service/module-log-level", new DomParserContext.AttributeConfig().name("level").defaultValue("INFO"));
        parserContext.addAttributeConfig("server/log-service/module-log-level", new DomParserContext.AttributeConfig().name("logger-names").required(true));
        return parserContext;
    }
}

