/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.config.provider;

import com.bes.enterprise.config.provider.ConfigProvider;
import com.bes.enterprise.config.provider.ConfigProviderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Map;

public class FileConfigProvider
implements ConfigProvider {
    public static String FILE_URI = PROVIDER_PREFIX + "FILE_URI";
    private String configFileLocation;

    public FileConfigProvider(Map<String, String> configProperties) throws ConfigProviderException {
        this.configFileLocation = configProperties.get(FILE_URI);
        if (this.configFileLocation == null) {
            this.configFileLocation = configProperties.get(PROVIDER_URI);
        }
        if (this.configFileLocation == null) {
            throw new ConfigProviderException("Missing property: " + FILE_URI + "!");
        }
    }

    @Override
    public String getIdentifier() {
        File configFile = new File(this.configFileLocation);
        URI uri = configFile.toURI();
        return uri.toString();
    }

    @Override
    public String getConfigText() throws ConfigProviderException {
        BufferedReader reader = null;
        FileInputStream fIn = null;
        try {
            File configFile = new File(this.configFileLocation);
            fIn = new FileInputStream(configFile);
            reader = new BufferedReader(new InputStreamReader(fIn));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException ioEx) {
            String errMsg = String.format("Failure to load the config from %s!", this.configFileLocation);
            throw new ConfigProviderException(errMsg, ioEx);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

