/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.ConnectionReuseStrategy;
import com.bes.enterprise.hc.core.http.Header;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.HttpResponse;
import com.bes.enterprise.hc.core.http.HttpVersion;
import com.bes.enterprise.hc.core.http.ProtocolVersion;
import com.bes.enterprise.hc.core.http.message.BasicTokenIterator;
import com.bes.enterprise.hc.core.http.message.MessageSupport;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import com.bes.enterprise.hc.core.util.Args;
import java.util.Iterator;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    public static final DefaultConnectionReuseStrategy INSTANCE = new DefaultConnectionReuseStrategy();

    @Override
    public boolean keepAlive(HttpRequest request, HttpResponse response, HttpContext context) {
        ProtocolVersion ver;
        Iterator<Header> headerIterator;
        Header teh;
        Args.notNull(response, "HTTP response");
        if (request != null) {
            BasicTokenIterator ti = new BasicTokenIterator(request.headerIterator("Connection"));
            while (ti.hasNext()) {
                String token = (String)ti.next();
                if (!"close".equalsIgnoreCase(token)) continue;
                return false;
            }
        }
        if (response.getCode() == 204) {
            Header clh = response.getFirstHeader("Content-Length");
            if (clh != null) {
                try {
                    long contentLen = Long.parseLong(clh.getValue());
                    if (contentLen > 0L) {
                        return false;
                    }
                }
                catch (NumberFormatException contentLen) {
                    // empty catch block
                }
            }
            if (response.containsHeader("Transfer-Encoding")) {
                return false;
            }
        }
        if ((teh = response.getFirstHeader("Transfer-Encoding")) != null) {
            if (!"chunked".equalsIgnoreCase(teh.getValue())) {
                return false;
            }
        } else {
            String method;
            String string = method = request != null ? request.getMethod() : null;
            if (MessageSupport.canResponseHaveBody(method, response) && response.countHeaders("Content-Length") != 1) {
                return false;
            }
        }
        if (!(headerIterator = response.headerIterator("Connection")).hasNext()) {
            headerIterator = response.headerIterator("Proxy-Connection");
        }
        ProtocolVersion protocolVersion = ver = response.getVersion() != null ? response.getVersion() : context.getProtocolVersion();
        if (headerIterator.hasNext()) {
            if (ver.greaterEquals(HttpVersion.HTTP_1_1)) {
                BasicTokenIterator it = new BasicTokenIterator(headerIterator);
                while (it.hasNext()) {
                    String token = (String)it.next();
                    if (!"close".equalsIgnoreCase(token)) continue;
                    return false;
                }
                return true;
            }
            BasicTokenIterator it = new BasicTokenIterator(headerIterator);
            while (it.hasNext()) {
                String token = (String)it.next();
                if (!"keep-alive".equalsIgnoreCase(token)) continue;
                return true;
            }
            return false;
        }
        return ver.greaterEquals(HttpVersion.HTTP_1_1);
    }
}

