/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl;

import com.bes.enterprise.hc.core.annotation.Internal;
import com.bes.enterprise.hc.core.http.EntityDetails;
import com.bes.enterprise.hc.core.http.Header;
import com.bes.enterprise.hc.core.http.MessageHeaders;
import com.bes.enterprise.hc.core.http.message.MessageSupport;
import com.bes.enterprise.hc.core.util.Args;
import java.util.Collections;
import java.util.Set;

@Internal
public class IncomingEntityDetails
implements EntityDetails {
    private final MessageHeaders message;
    private final long contentLength;

    public IncomingEntityDetails(MessageHeaders message, long contentLength) {
        this.message = Args.notNull(message, "Message");
        this.contentLength = contentLength;
    }

    public IncomingEntityDetails(MessageHeaders message) {
        this(message, -1L);
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        Header h2 = this.message.getFirstHeader("Content-Type");
        return h2 != null ? h2.getValue() : null;
    }

    @Override
    public String getContentEncoding() {
        Header h2 = this.message.getFirstHeader("Content-Encoding");
        return h2 != null ? h2.getValue() : null;
    }

    @Override
    public boolean isChunked() {
        return this.contentLength < 0L;
    }

    @Override
    public Set<String> getTrailerNames() {
        Header h2 = this.message.getFirstHeader("Trailer");
        if (h2 == null) {
            return Collections.emptySet();
        }
        return MessageSupport.parseTokens(h2);
    }
}

