/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl;

import com.bes.enterprise.hc.core.annotation.Internal;
import com.bes.enterprise.hc.core.http.EntityDetails;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpResponse;
import com.bes.enterprise.hc.core.http.MethodNotSupportedException;
import com.bes.enterprise.hc.core.http.MisdirectedRequestException;
import com.bes.enterprise.hc.core.http.NotImplementedException;
import com.bes.enterprise.hc.core.http.ProtocolException;
import com.bes.enterprise.hc.core.http.RequestHeaderFieldsTooLargeException;
import com.bes.enterprise.hc.core.http.UnsupportedHttpVersionException;

@Internal
public class ServerSupport {
    public static void validateResponse(HttpResponse response, EntityDetails responseEntityDetails) throws HttpException {
        int status = response.getCode();
        switch (status) {
            case 204: 
            case 304: {
                if (responseEntityDetails == null) break;
                throw new HttpException("Response " + status + " must not enclose an entity");
            }
        }
    }

    public static String toErrorMessage(Exception ex) {
        String message = ex.getMessage();
        return message != null ? message : ex.toString();
    }

    public static int toStatusCode(Exception ex) {
        int code = ex instanceof MethodNotSupportedException ? 501 : (ex instanceof UnsupportedHttpVersionException ? 505 : (ex instanceof NotImplementedException ? 501 : (ex instanceof RequestHeaderFieldsTooLargeException ? 431 : (ex instanceof MisdirectedRequestException ? 421 : (ex instanceof ProtocolException ? 400 : 500)))));
        return code;
    }
}

