/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.bootstrap;

import com.bes.enterprise.hc.core.annotation.Internal;
import com.bes.enterprise.hc.core.concurrent.DefaultThreadFactory;
import com.bes.enterprise.hc.core.concurrent.FutureCallback;
import com.bes.enterprise.hc.core.function.Callback;
import com.bes.enterprise.hc.core.function.Decorator;
import com.bes.enterprise.hc.core.function.Resolver;
import com.bes.enterprise.hc.core.http.HttpHost;
import com.bes.enterprise.hc.core.http.impl.DefaultAddressResolver;
import com.bes.enterprise.hc.core.http.impl.bootstrap.AbstractConnectionInitiatorBase;
import com.bes.enterprise.hc.core.io.CloseMode;
import com.bes.enterprise.hc.core.reactor.ConnectionInitiator;
import com.bes.enterprise.hc.core.reactor.DefaultConnectingIOReactor;
import com.bes.enterprise.hc.core.reactor.IOEventHandlerFactory;
import com.bes.enterprise.hc.core.reactor.IOReactorConfig;
import com.bes.enterprise.hc.core.reactor.IOReactorService;
import com.bes.enterprise.hc.core.reactor.IOReactorStatus;
import com.bes.enterprise.hc.core.reactor.IOSession;
import com.bes.enterprise.hc.core.reactor.IOSessionListener;
import com.bes.enterprise.hc.core.util.Args;
import com.bes.enterprise.hc.core.util.TimeValue;
import com.bes.enterprise.hc.core.util.Timeout;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;

public class AsyncRequester
extends AbstractConnectionInitiatorBase
implements IOReactorService {
    private final DefaultConnectingIOReactor ioReactor;
    private final Resolver<HttpHost, InetSocketAddress> addressResolver;

    @Internal
    public AsyncRequester(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, Decorator<IOSession> ioSessionDecorator, Callback<Exception> exceptionCallback, IOSessionListener sessionListener, Callback<IOSession> sessionShutdownCallback, Resolver<HttpHost, InetSocketAddress> addressResolver) {
        this.ioReactor = new DefaultConnectingIOReactor(eventHandlerFactory, ioReactorConfig, new DefaultThreadFactory("requester-dispatch", true), ioSessionDecorator, exceptionCallback, sessionListener, sessionShutdownCallback);
        this.addressResolver = addressResolver != null ? addressResolver : DefaultAddressResolver.INSTANCE;
    }

    @Override
    ConnectionInitiator getIOReactor() {
        return this.ioReactor;
    }

    public Future<IOSession> requestSession(HttpHost host, Timeout timeout, Object attachment, FutureCallback<IOSession> callback) {
        Args.notNull(host, "Host");
        Args.notNull(timeout, "Timeout");
        return this.connect(host, this.addressResolver.resolve(host), null, timeout, attachment, callback);
    }

    @Override
    public void start() {
        this.ioReactor.start();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    public void initiateShutdown() {
        this.ioReactor.initiateShutdown();
    }

    @Override
    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        this.ioReactor.awaitShutdown(waitTime);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioReactor.close(closeMode);
    }

    @Override
    public void close() throws IOException {
        this.ioReactor.close();
    }
}

