/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.bootstrap;

import com.bes.enterprise.hc.core.annotation.Experimental;
import com.bes.enterprise.hc.core.function.Callback;
import com.bes.enterprise.hc.core.function.Decorator;
import com.bes.enterprise.hc.core.http.ConnectionReuseStrategy;
import com.bes.enterprise.hc.core.http.HttpHost;
import com.bes.enterprise.hc.core.http.config.CharCodingConfig;
import com.bes.enterprise.hc.core.http.config.Http1Config;
import com.bes.enterprise.hc.core.http.impl.Http1StreamListener;
import com.bes.enterprise.hc.core.http.impl.HttpProcessors;
import com.bes.enterprise.hc.core.http.impl.bootstrap.HttpAsyncRequester;
import com.bes.enterprise.hc.core.http.impl.nio.ClientHttp1IOEventHandlerFactory;
import com.bes.enterprise.hc.core.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import com.bes.enterprise.hc.core.http.nio.ssl.BasicClientTlsStrategy;
import com.bes.enterprise.hc.core.http.nio.ssl.TlsStrategy;
import com.bes.enterprise.hc.core.http.protocol.HttpProcessor;
import com.bes.enterprise.hc.core.pool.ConnPoolListener;
import com.bes.enterprise.hc.core.pool.DefaultDisposalCallback;
import com.bes.enterprise.hc.core.pool.LaxConnPool;
import com.bes.enterprise.hc.core.pool.PoolConcurrencyPolicy;
import com.bes.enterprise.hc.core.pool.PoolReusePolicy;
import com.bes.enterprise.hc.core.pool.StrictConnPool;
import com.bes.enterprise.hc.core.reactor.IOReactorConfig;
import com.bes.enterprise.hc.core.reactor.IOSession;
import com.bes.enterprise.hc.core.reactor.IOSessionListener;
import com.bes.enterprise.hc.core.util.Timeout;

public class AsyncRequesterBootstrap {
    private IOReactorConfig ioReactorConfig;
    private Http1Config http1Config;
    private CharCodingConfig charCodingConfig;
    private HttpProcessor httpProcessor;
    private ConnectionReuseStrategy connStrategy;
    private int defaultMaxPerRoute;
    private int maxTotal;
    private Timeout timeToLive;
    private PoolReusePolicy poolReusePolicy;
    private PoolConcurrencyPolicy poolConcurrencyPolicy;
    private TlsStrategy tlsStrategy;
    private Timeout handshakeTimeout;
    private Decorator<IOSession> ioSessionDecorator;
    private Callback<Exception> exceptionCallback;
    private IOSessionListener sessionListener;
    private Http1StreamListener streamListener;
    private ConnPoolListener<HttpHost> connPoolListener;

    private AsyncRequesterBootstrap() {
    }

    public static AsyncRequesterBootstrap bootstrap() {
        return new AsyncRequesterBootstrap();
    }

    public final AsyncRequesterBootstrap setIOReactorConfig(IOReactorConfig ioReactorConfig) {
        this.ioReactorConfig = ioReactorConfig;
        return this;
    }

    public final AsyncRequesterBootstrap setHttp1Config(Http1Config http1Config) {
        this.http1Config = http1Config;
        return this;
    }

    public final AsyncRequesterBootstrap setCharCodingConfig(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final AsyncRequesterBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final AsyncRequesterBootstrap setConnectionReuseStrategy(ConnectionReuseStrategy connStrategy) {
        this.connStrategy = connStrategy;
        return this;
    }

    public final AsyncRequesterBootstrap setDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
        return this;
    }

    public final AsyncRequesterBootstrap setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
        return this;
    }

    public final AsyncRequesterBootstrap setTimeToLive(Timeout timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    public final AsyncRequesterBootstrap setPoolReusePolicy(PoolReusePolicy poolReusePolicy) {
        this.poolReusePolicy = poolReusePolicy;
        return this;
    }

    @Experimental
    public final AsyncRequesterBootstrap setPoolConcurrencyPolicy(PoolConcurrencyPolicy poolConcurrencyPolicy) {
        this.poolConcurrencyPolicy = poolConcurrencyPolicy;
        return this;
    }

    public final AsyncRequesterBootstrap setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final AsyncRequesterBootstrap setTlsHandshakeTimeout(Timeout handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
        return this;
    }

    public final AsyncRequesterBootstrap setIOSessionDecorator(Decorator<IOSession> ioSessionDecorator) {
        this.ioSessionDecorator = ioSessionDecorator;
        return this;
    }

    public final AsyncRequesterBootstrap setExceptionCallback(Callback<Exception> exceptionCallback) {
        this.exceptionCallback = exceptionCallback;
        return this;
    }

    public final AsyncRequesterBootstrap setIOSessionListener(IOSessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public final AsyncRequesterBootstrap setStreamListener(Http1StreamListener streamListener) {
        this.streamListener = streamListener;
        return this;
    }

    public final AsyncRequesterBootstrap setConnPoolListener(ConnPoolListener<HttpHost> connPoolListener) {
        this.connPoolListener = connPoolListener;
        return this;
    }

    public HttpAsyncRequester create() {
        LaxConnPool<HttpHost, IOSession> connPool;
        switch (this.poolConcurrencyPolicy != null ? this.poolConcurrencyPolicy : PoolConcurrencyPolicy.STRICT) {
            case LAX: {
                connPool = new LaxConnPool(this.defaultMaxPerRoute > 0 ? this.defaultMaxPerRoute : 20, this.timeToLive, this.poolReusePolicy, new DefaultDisposalCallback(), this.connPoolListener);
                break;
            }
            default: {
                connPool = new StrictConnPool(this.defaultMaxPerRoute > 0 ? this.defaultMaxPerRoute : 20, this.maxTotal > 0 ? this.maxTotal : 50, this.timeToLive, this.poolReusePolicy, new DefaultDisposalCallback(), this.connPoolListener);
            }
        }
        ClientHttp1StreamDuplexerFactory streamDuplexerFactory = new ClientHttp1StreamDuplexerFactory(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.client(), this.http1Config != null ? this.http1Config : Http1Config.DEFAULT, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, this.connStrategy, null, null, this.streamListener);
        ClientHttp1IOEventHandlerFactory ioEventHandlerFactory = new ClientHttp1IOEventHandlerFactory(streamDuplexerFactory, this.tlsStrategy != null ? this.tlsStrategy : new BasicClientTlsStrategy(), this.handshakeTimeout);
        return new HttpAsyncRequester(this.ioReactorConfig, ioEventHandlerFactory, this.ioSessionDecorator, this.exceptionCallback, this.sessionListener, connPool);
    }
}

