/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.io;

import com.bes.enterprise.hc.core.http.FormattedHeader;
import com.bes.enterprise.hc.core.http.Header;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpMessage;
import com.bes.enterprise.hc.core.http.io.HttpMessageWriter;
import com.bes.enterprise.hc.core.http.io.SessionOutputBuffer;
import com.bes.enterprise.hc.core.http.message.BasicLineFormatter;
import com.bes.enterprise.hc.core.http.message.LineFormatter;
import com.bes.enterprise.hc.core.util.Args;
import com.bes.enterprise.hc.core.util.CharArrayBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    private final CharArrayBuffer lineBuf;
    private final LineFormatter lineFormatter;

    public AbstractMessageWriter(LineFormatter formatter) {
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    LineFormatter getLineFormatter() {
        return this.lineFormatter;
    }

    protected abstract void writeHeadLine(T var1, CharArrayBuffer var2) throws IOException;

    @Override
    public void write(T message, SessionOutputBuffer buffer, OutputStream outputStream) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        Args.notNull(buffer, "Session output buffer");
        Args.notNull(outputStream, "Output stream");
        this.writeHeadLine(message, this.lineBuf);
        buffer.writeLine(this.lineBuf, outputStream);
        Iterator<Header> it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.next();
            if (header instanceof FormattedHeader) {
                CharArrayBuffer chbuffer = ((FormattedHeader)header).getBuffer();
                buffer.writeLine(chbuffer, outputStream);
                continue;
            }
            this.lineBuf.clear();
            this.lineFormatter.formatHeader(this.lineBuf, header);
            buffer.writeLine(this.lineBuf, outputStream);
        }
        this.lineBuf.clear();
        buffer.writeLine(this.lineBuf, outputStream);
    }
}

