/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.io;

import com.bes.enterprise.hc.core.http.ClassicHttpRequest;
import com.bes.enterprise.hc.core.http.ConnectionClosedException;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpRequestFactory;
import com.bes.enterprise.hc.core.http.MessageConstraintException;
import com.bes.enterprise.hc.core.http.RequestHeaderFieldsTooLargeException;
import com.bes.enterprise.hc.core.http.config.Http1Config;
import com.bes.enterprise.hc.core.http.impl.io.AbstractMessageParser;
import com.bes.enterprise.hc.core.http.impl.io.DefaultClassicHttpRequestFactory;
import com.bes.enterprise.hc.core.http.io.SessionInputBuffer;
import com.bes.enterprise.hc.core.http.message.LineParser;
import com.bes.enterprise.hc.core.http.message.RequestLine;
import com.bes.enterprise.hc.core.util.CharArrayBuffer;
import java.io.IOException;
import java.io.InputStream;

public class DefaultHttpRequestParser
extends AbstractMessageParser<ClassicHttpRequest> {
    private final HttpRequestFactory<ClassicHttpRequest> requestFactory;

    public DefaultHttpRequestParser(LineParser lineParser, HttpRequestFactory<ClassicHttpRequest> requestFactory, Http1Config http1Config) {
        super(lineParser, http1Config);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultClassicHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParser(Http1Config http1Config) {
        this(null, null, http1Config);
    }

    public DefaultHttpRequestParser() {
        this(Http1Config.DEFAULT);
    }

    @Override
    protected IOException createConnectionClosedException() {
        return new ConnectionClosedException("Client closed connection");
    }

    @Override
    public ClassicHttpRequest parse(SessionInputBuffer buffer, InputStream inputStream) throws IOException, HttpException {
        try {
            return (ClassicHttpRequest)super.parse(buffer, inputStream);
        }
        catch (MessageConstraintException ex) {
            throw new RequestHeaderFieldsTooLargeException(ex.getMessage(), ex);
        }
    }

    @Override
    protected ClassicHttpRequest createMessage(CharArrayBuffer buffer) throws IOException, HttpException {
        RequestLine requestLine = this.getLineParser().parseRequestLine(buffer);
        ClassicHttpRequest request = this.requestFactory.newHttpRequest(requestLine.getMethod(), requestLine.getUri());
        request.setVersion(requestLine.getProtocolVersion());
        return request;
    }
}

