/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.io;

import com.bes.enterprise.hc.core.http.ClassicHttpResponse;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpResponseFactory;
import com.bes.enterprise.hc.core.http.NoHttpResponseException;
import com.bes.enterprise.hc.core.http.config.Http1Config;
import com.bes.enterprise.hc.core.http.impl.io.AbstractMessageParser;
import com.bes.enterprise.hc.core.http.impl.io.DefaultClassicHttpResponseFactory;
import com.bes.enterprise.hc.core.http.message.LineParser;
import com.bes.enterprise.hc.core.http.message.StatusLine;
import com.bes.enterprise.hc.core.util.CharArrayBuffer;
import java.io.IOException;

public class DefaultHttpResponseParser
extends AbstractMessageParser<ClassicHttpResponse> {
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public DefaultHttpResponseParser(LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> responseFactory, Http1Config http1Config) {
        super(lineParser, http1Config);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParser(Http1Config http1Config) {
        this(null, null, http1Config);
    }

    public DefaultHttpResponseParser() {
        this(Http1Config.DEFAULT);
    }

    @Override
    protected IOException createConnectionClosedException() {
        return new NoHttpResponseException("The target server failed to respond");
    }

    @Override
    protected ClassicHttpResponse createMessage(CharArrayBuffer buffer) throws IOException, HttpException {
        StatusLine statusline = this.getLineParser().parseStatusLine(buffer);
        ClassicHttpResponse response = this.responseFactory.newHttpResponse(statusline.getStatusCode(), statusline.getReasonPhrase());
        response.setVersion(statusline.getProtocolVersion());
        return response;
    }
}

