/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.io;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.ClassicHttpResponse;
import com.bes.enterprise.hc.core.http.HttpResponseFactory;
import com.bes.enterprise.hc.core.http.config.Http1Config;
import com.bes.enterprise.hc.core.http.impl.io.DefaultClassicHttpResponseFactory;
import com.bes.enterprise.hc.core.http.impl.io.DefaultHttpResponseParser;
import com.bes.enterprise.hc.core.http.io.HttpMessageParser;
import com.bes.enterprise.hc.core.http.io.HttpMessageParserFactory;
import com.bes.enterprise.hc.core.http.message.LazyLaxLineParser;
import com.bes.enterprise.hc.core.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<ClassicHttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> responseFactory) {
        this.lineParser = lineParser != null ? lineParser : LazyLaxLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<ClassicHttpResponse> create(Http1Config http1Config) {
        return new DefaultHttpResponseParser(this.lineParser, this.responseFactory, http1Config);
    }
}

