/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.io;

import com.bes.enterprise.hc.core.http.StreamClosedException;
import com.bes.enterprise.hc.core.http.io.SessionOutputBuffer;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;
import java.io.OutputStream;

public class IdentityOutputStream
extends OutputStream {
    private final SessionOutputBuffer buffer;
    private final OutputStream outputStream;
    private boolean closed;

    public IdentityOutputStream(SessionOutputBuffer buffer, OutputStream outputStream) {
        this.buffer = Args.notNull(buffer, "Session output buffer");
        this.outputStream = Args.notNull(outputStream, "Output stream");
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.buffer.flush(this.outputStream);
        }
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush(this.outputStream);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.closed) {
            throw new StreamClosedException();
        }
        this.buffer.write(b2, off, len, this.outputStream);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(int b2) throws IOException {
        if (this.closed) {
            throw new StreamClosedException();
        }
        this.buffer.write(b2, this.outputStream);
    }
}

