/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.nio;

import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.HttpRequestFactory;
import com.bes.enterprise.hc.core.http.MessageConstraintException;
import com.bes.enterprise.hc.core.http.RequestHeaderFieldsTooLargeException;
import com.bes.enterprise.hc.core.http.config.Http1Config;
import com.bes.enterprise.hc.core.http.impl.nio.AbstractMessageParser;
import com.bes.enterprise.hc.core.http.message.LineParser;
import com.bes.enterprise.hc.core.http.message.RequestLine;
import com.bes.enterprise.hc.core.http.nio.SessionInputBuffer;
import com.bes.enterprise.hc.core.util.Args;
import com.bes.enterprise.hc.core.util.CharArrayBuffer;
import java.io.IOException;

public class DefaultHttpRequestParser<T extends HttpRequest>
extends AbstractMessageParser<T> {
    private final HttpRequestFactory<T> requestFactory;

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory, LineParser parser, Http1Config http1Config) {
        super(parser, http1Config);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
    }

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory, Http1Config http1Config) {
        this(requestFactory, null, http1Config);
    }

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory) {
        this(requestFactory, null);
    }

    @Override
    public T parse(SessionInputBuffer sessionBuffer, boolean endOfStream) throws IOException, HttpException {
        try {
            return (T)((HttpRequest)super.parse(sessionBuffer, endOfStream));
        }
        catch (MessageConstraintException ex) {
            throw new RequestHeaderFieldsTooLargeException(ex.getMessage(), ex);
        }
    }

    @Override
    protected T createMessage(CharArrayBuffer buffer) throws HttpException {
        RequestLine requestLine = this.getLineParser().parseRequestLine(buffer);
        T request = this.requestFactory.newHttpRequest(requestLine.getMethod(), requestLine.getUri());
        request.setVersion(requestLine.getProtocolVersion());
        return request;
    }
}

