/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.io.entity;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.ContentType;
import com.bes.enterprise.hc.core.http.io.entity.AbstractHttpEntity;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class PathEntity
extends AbstractHttpEntity {
    private final Path path;

    public PathEntity(Path path, ContentType contentType, String contentEncoding) {
        super(contentType, contentEncoding);
        this.path = Args.notNull(path, "Path");
    }

    public PathEntity(Path path, ContentType contentType) {
        super(contentType, null);
        this.path = Args.notNull(path, "Path");
    }

    @Override
    public final boolean isRepeatable() {
        return true;
    }

    @Override
    public final long getContentLength() {
        try {
            return Files.size(this.path);
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public final InputStream getContent() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public final boolean isStreaming() {
        return false;
    }

    @Override
    public final void close() throws IOException {
    }
}

