/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.message;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.Header;
import com.bes.enterprise.hc.core.http.HttpVersion;
import com.bes.enterprise.hc.core.http.ParseException;
import com.bes.enterprise.hc.core.http.ProtocolVersion;
import com.bes.enterprise.hc.core.http.message.BasicHeader;
import com.bes.enterprise.hc.core.http.message.LineParser;
import com.bes.enterprise.hc.core.http.message.ParserCursor;
import com.bes.enterprise.hc.core.http.message.RequestLine;
import com.bes.enterprise.hc.core.http.message.StatusLine;
import com.bes.enterprise.hc.core.util.Args;
import com.bes.enterprise.hc.core.util.CharArrayBuffer;
import com.bes.enterprise.hc.core.util.TextUtils;
import com.bes.enterprise.hc.core.util.Tokenizer;
import java.util.BitSet;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicLineParser
implements LineParser {
    public static final BasicLineParser INSTANCE = new BasicLineParser();
    private static final BitSet FULL_STOP = Tokenizer.INIT_BITSET(46);
    private static final BitSet BLANKS = Tokenizer.INIT_BITSET(32, 9);
    private static final BitSet COLON = Tokenizer.INIT_BITSET(58);
    private final ProtocolVersion protocol;
    private final Tokenizer tokenizer;

    public BasicLineParser(ProtocolVersion proto) {
        this.protocol = proto != null ? proto : HttpVersion.HTTP_1_1;
        this.tokenizer = Tokenizer.INSTANCE;
    }

    public BasicLineParser() {
        this(null);
    }

    ProtocolVersion parseProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        int minor;
        int major;
        String protoname = this.protocol.getProtocol();
        int protolength = protoname.length();
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        int pos = cursor.getPos();
        if (pos + protolength + 4 > cursor.getUpperBound()) {
            throw new ParseException("Invalid protocol version", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        boolean ok = true;
        for (int i2 = 0; ok && i2 < protolength; ++i2) {
            ok = buffer.charAt(pos + i2) == protoname.charAt(i2);
        }
        if (ok) {
            boolean bl = ok = buffer.charAt(pos + protolength) == '/';
        }
        if (!ok) {
            throw new ParseException("Invalid protocol version", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        cursor.updatePos(pos + protolength + 1);
        String token1 = this.tokenizer.parseToken(buffer, cursor, FULL_STOP);
        try {
            major = Integer.parseInt(token1);
        }
        catch (NumberFormatException e2) {
            throw new ParseException("Invalid protocol major version number", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        if (cursor.atEnd()) {
            throw new ParseException("Invalid protocol version", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        cursor.updatePos(cursor.getPos() + 1);
        String token2 = this.tokenizer.parseToken(buffer, cursor, BLANKS);
        try {
            minor = Integer.parseInt(token2);
        }
        catch (NumberFormatException e3) {
            throw new ParseException("Invalid protocol minor version number", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        return HttpVersion.get(major, minor);
    }

    @Override
    public RequestLine parseRequestLine(CharArrayBuffer buffer) throws ParseException {
        Args.notNull(buffer, "Char array buffer");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        String method = this.tokenizer.parseToken(buffer, cursor, BLANKS);
        if (TextUtils.isEmpty(method)) {
            throw new ParseException("Invalid request line", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        String uri = this.tokenizer.parseToken(buffer, cursor, BLANKS);
        if (TextUtils.isEmpty(uri)) {
            throw new ParseException("Invalid request line", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        ProtocolVersion ver = this.parseProtocolVersion(buffer, cursor);
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        if (!cursor.atEnd()) {
            throw new ParseException("Invalid request line", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        return new RequestLine(method, uri, ver);
    }

    @Override
    public StatusLine parseStatusLine(CharArrayBuffer buffer) throws ParseException {
        int statusCode;
        Args.notNull(buffer, "Char array buffer");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        ProtocolVersion ver = this.parseProtocolVersion(buffer, cursor);
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        String s2 = this.tokenizer.parseToken(buffer, cursor, BLANKS);
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (Character.isDigit(s2.charAt(i2))) continue;
            throw new ParseException("Status line contains invalid status code", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        try {
            statusCode = Integer.parseInt(s2);
        }
        catch (NumberFormatException e2) {
            throw new ParseException("Status line contains invalid status code", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        String text = buffer.substringTrimmed(cursor.getPos(), cursor.getUpperBound());
        return new StatusLine(ver, statusCode, text);
    }

    @Override
    public Header parseHeader(CharArrayBuffer buffer) throws ParseException {
        Args.notNull(buffer, "Char array buffer");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        this.tokenizer.skipWhiteSpace(buffer, cursor);
        String name = this.tokenizer.parseToken(buffer, cursor, COLON);
        if (cursor.getPos() == cursor.getLowerBound() || cursor.getPos() == cursor.getUpperBound() || buffer.charAt(cursor.getPos()) != ':' || TextUtils.isEmpty(name) || Tokenizer.isWhitespace(buffer.charAt(cursor.getPos() - 1))) {
            throw new ParseException("Invalid header", buffer, cursor.getLowerBound(), cursor.getUpperBound(), cursor.getPos());
        }
        String value = buffer.substringTrimmed(cursor.getPos() + 1, cursor.getUpperBound());
        return new BasicHeader(name, value);
    }
}

