/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.concurrent.BasicFuture;
import com.bes.enterprise.hc.core.concurrent.FutureCallback;
import com.bes.enterprise.hc.core.concurrent.FutureContribution;
import com.bes.enterprise.hc.core.http.nio.AsyncClientExchangeHandler;
import com.bes.enterprise.hc.core.http.nio.AsyncPushConsumer;
import com.bes.enterprise.hc.core.http.nio.AsyncRequestProducer;
import com.bes.enterprise.hc.core.http.nio.AsyncResponseConsumer;
import com.bes.enterprise.hc.core.http.nio.HandlerFactory;
import com.bes.enterprise.hc.core.http.nio.support.BasicClientExchangeHandler;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import com.bes.enterprise.hc.core.http.protocol.HttpCoreContext;
import java.util.concurrent.Future;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class AsyncClientEndpoint {
    public abstract void execute(AsyncClientExchangeHandler var1, HandlerFactory<AsyncPushConsumer> var2, HttpContext var3);

    public void execute(AsyncClientExchangeHandler exchangeHandler, HttpContext context) {
        this.execute(exchangeHandler, null, context);
    }

    public abstract void releaseAndReuse();

    public abstract void releaseAndDiscard();

    public abstract boolean isConnected();

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context, FutureCallback<T> callback) {
        final BasicFuture<T> future = new BasicFuture<T>(callback);
        this.execute(new BasicClientExchangeHandler<T>(requestProducer, responseConsumer, new FutureContribution<T>(future){

            @Override
            public void completed(T result) {
                future.completed(result);
            }
        }), pushHandlerFactory, context != null ? context : HttpCoreContext.create());
        return future;
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, null, context, callback);
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, null, null, callback);
    }
}

