/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.command;

import com.bes.enterprise.hc.core.annotation.Internal;
import com.bes.enterprise.hc.core.concurrent.CancellableDependency;
import com.bes.enterprise.hc.core.http.RequestNotExecutedException;
import com.bes.enterprise.hc.core.http.nio.AsyncClientExchangeHandler;
import com.bes.enterprise.hc.core.http.nio.AsyncPushConsumer;
import com.bes.enterprise.hc.core.http.nio.HandlerFactory;
import com.bes.enterprise.hc.core.http.nio.command.ExecutableCommand;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import com.bes.enterprise.hc.core.util.Args;
import java.util.concurrent.atomic.AtomicBoolean;

@Internal
public final class RequestExecutionCommand
extends ExecutableCommand {
    private final AsyncClientExchangeHandler exchangeHandler;
    private final HandlerFactory<AsyncPushConsumer> pushHandlerFactory;
    private final CancellableDependency cancellableDependency;
    private final HttpContext context;
    private final AtomicBoolean failed;

    public RequestExecutionCommand(AsyncClientExchangeHandler exchangeHandler, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, CancellableDependency cancellableDependency, HttpContext context) {
        this.exchangeHandler = Args.notNull(exchangeHandler, "Handler");
        this.pushHandlerFactory = pushHandlerFactory;
        this.cancellableDependency = cancellableDependency;
        this.context = context;
        this.failed = new AtomicBoolean();
    }

    public RequestExecutionCommand(AsyncClientExchangeHandler exchangeHandler, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context) {
        this(exchangeHandler, pushHandlerFactory, null, context);
    }

    public RequestExecutionCommand(AsyncClientExchangeHandler exchangeHandler, HttpContext context) {
        this(exchangeHandler, null, null, context);
    }

    public AsyncClientExchangeHandler getExchangeHandler() {
        return this.exchangeHandler;
    }

    public HandlerFactory<AsyncPushConsumer> getPushHandlerFactory() {
        return this.pushHandlerFactory;
    }

    @Override
    public CancellableDependency getCancellableDependency() {
        return this.cancellableDependency;
    }

    public HttpContext getContext() {
        return this.context;
    }

    @Override
    public void failed(Exception ex) {
        if (this.failed.compareAndSet(false, true)) {
            try {
                this.exchangeHandler.failed(ex);
            }
            finally {
                this.exchangeHandler.releaseResources();
            }
        }
    }

    @Override
    public boolean cancel() {
        if (this.failed.compareAndSet(false, true)) {
            try {
                this.exchangeHandler.failed(new RequestNotExecutedException());
                boolean bl = true;
                return bl;
            }
            finally {
                this.exchangeHandler.releaseResources();
            }
        }
        return false;
    }
}

