/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.ssl;

import com.bes.enterprise.hc.core.http.HttpHost;
import com.bes.enterprise.hc.core.http.URIScheme;
import com.bes.enterprise.hc.core.http.nio.ssl.TlsStrategy;
import com.bes.enterprise.hc.core.http.nio.ssl.TlsSupport;
import com.bes.enterprise.hc.core.reactor.ssl.SSLBufferMode;
import com.bes.enterprise.hc.core.reactor.ssl.SSLSessionInitializer;
import com.bes.enterprise.hc.core.reactor.ssl.SSLSessionVerifier;
import com.bes.enterprise.hc.core.reactor.ssl.TransportSecurityLayer;
import com.bes.enterprise.hc.core.ssl.SSLContexts;
import com.bes.enterprise.hc.core.util.Args;
import com.bes.enterprise.hc.core.util.Timeout;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;

public class BasicClientTlsStrategy
implements TlsStrategy {
    private final SSLContext sslContext;
    private final SSLBufferMode sslBufferMode;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;

    public BasicClientTlsStrategy(SSLContext sslContext, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this.sslContext = Args.notNull(sslContext, "SSL context");
        this.sslBufferMode = sslBufferMode;
        this.initializer = initializer;
        this.verifier = verifier;
    }

    public BasicClientTlsStrategy(SSLContext sslContext, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this(sslContext, null, initializer, verifier);
    }

    public BasicClientTlsStrategy(SSLContext sslContext, SSLSessionVerifier verifier) {
        this(sslContext, null, null, verifier);
    }

    public BasicClientTlsStrategy(SSLContext sslContext) {
        this(sslContext, null, null, null);
    }

    public BasicClientTlsStrategy() {
        this(SSLContexts.createSystemDefault());
    }

    @Override
    public boolean upgrade(TransportSecurityLayer tlsSession, HttpHost host, SocketAddress localAddress, SocketAddress remoteAddress, Object attachment, Timeout handshakeTimeout) {
        String scheme;
        String string = scheme = host != null ? host.getSchemeName() : null;
        if (URIScheme.HTTPS.same(scheme)) {
            tlsSession.startTls(this.sslContext, host, this.sslBufferMode, TlsSupport.enforceStrongSecurity(this.initializer), this.verifier, handshakeTimeout);
            return true;
        }
        return false;
    }
}

