/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.support;

import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpResponse;
import com.bes.enterprise.hc.core.http.message.BasicHttpResponse;
import com.bes.enterprise.hc.core.http.nio.AsyncEntityProducer;
import com.bes.enterprise.hc.core.http.nio.AsyncPushProducer;
import com.bes.enterprise.hc.core.http.nio.DataStreamChannel;
import com.bes.enterprise.hc.core.http.nio.ResponseChannel;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;

public class BasicPushProducer
implements AsyncPushProducer {
    private final HttpResponse response;
    private final AsyncEntityProducer dataProducer;

    public BasicPushProducer(HttpResponse response, AsyncEntityProducer dataProducer) {
        this.response = Args.notNull(response, "Response");
        this.dataProducer = Args.notNull(dataProducer, "Entity producer");
    }

    public BasicPushProducer(int code, AsyncEntityProducer dataProducer) {
        this(new BasicHttpResponse(code), dataProducer);
    }

    public BasicPushProducer(AsyncEntityProducer dataProducer) {
        this(200, dataProducer);
    }

    @Override
    public void produceResponse(ResponseChannel channel, HttpContext httpContext) throws HttpException, IOException {
        channel.sendResponse(this.response, this.dataProducer, httpContext);
    }

    @Override
    public int available() {
        return this.dataProducer != null ? this.dataProducer.available() : 0;
    }

    @Override
    public void produce(DataStreamChannel channel) throws IOException {
        if (this.dataProducer != null) {
            this.dataProducer.produce(channel);
        }
    }

    @Override
    public void failed(Exception cause) {
        this.releaseResources();
    }

    @Override
    public void releaseResources() {
        if (this.dataProducer != null) {
            this.dataProducer.releaseResources();
        }
    }
}

