/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.support;

import com.bes.enterprise.hc.core.concurrent.CallbackContribution;
import com.bes.enterprise.hc.core.concurrent.FutureCallback;
import com.bes.enterprise.hc.core.function.Supplier;
import com.bes.enterprise.hc.core.http.EntityDetails;
import com.bes.enterprise.hc.core.http.Header;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.Message;
import com.bes.enterprise.hc.core.http.nio.AsyncEntityConsumer;
import com.bes.enterprise.hc.core.http.nio.AsyncRequestConsumer;
import com.bes.enterprise.hc.core.http.nio.CapacityChannel;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class BasicRequestConsumer<T>
implements AsyncRequestConsumer<Message<HttpRequest, T>> {
    private final Supplier<AsyncEntityConsumer<T>> dataConsumerSupplier;
    private final AtomicReference<AsyncEntityConsumer<T>> dataConsumerRef;

    public BasicRequestConsumer(Supplier<AsyncEntityConsumer<T>> dataConsumerSupplier) {
        this.dataConsumerSupplier = Args.notNull(dataConsumerSupplier, "Data consumer supplier");
        this.dataConsumerRef = new AtomicReference();
    }

    public BasicRequestConsumer(final AsyncEntityConsumer<T> dataConsumer) {
        this(new Supplier<AsyncEntityConsumer<T>>(){

            @Override
            public AsyncEntityConsumer<T> get() {
                return dataConsumer;
            }
        });
    }

    @Override
    public void consumeRequest(final HttpRequest request, EntityDetails entityDetails, HttpContext httpContext, final FutureCallback<Message<HttpRequest, T>> resultCallback) throws HttpException, IOException {
        Args.notNull(request, "Request");
        if (entityDetails != null) {
            AsyncEntityConsumer<T> dataConsumer = this.dataConsumerSupplier.get();
            if (dataConsumer == null) {
                throw new HttpException("Supplied data consumer is null");
            }
            this.dataConsumerRef.set(dataConsumer);
            dataConsumer.streamStart(entityDetails, new CallbackContribution<T>(resultCallback){

                @Override
                public void completed(T body) {
                    Message result = new Message(request, body);
                    if (resultCallback != null) {
                        resultCallback.completed(result);
                    }
                }
            });
        } else {
            Message<HttpRequest, Object> result = new Message<HttpRequest, Object>(request, null);
            if (resultCallback != null) {
                resultCallback.completed(result);
            }
        }
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        AsyncEntityConsumer<T> dataConsumer = this.dataConsumerRef.get();
        dataConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public void consume(ByteBuffer src) throws IOException {
        AsyncEntityConsumer<T> dataConsumer = this.dataConsumerRef.get();
        dataConsumer.consume(src);
    }

    @Override
    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        AsyncEntityConsumer<T> dataConsumer = this.dataConsumerRef.get();
        dataConsumer.streamEnd(trailers);
    }

    @Override
    public void failed(Exception cause) {
        this.releaseResources();
    }

    @Override
    public void releaseResources() {
        AsyncEntityConsumer dataConsumer = this.dataConsumerRef.getAndSet(null);
        if (dataConsumer != null) {
            dataConsumer.releaseResources();
        }
    }
}

