/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.support;

import com.bes.enterprise.hc.core.function.Decorator;
import com.bes.enterprise.hc.core.function.Supplier;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.HttpRequestMapper;
import com.bes.enterprise.hc.core.http.MisdirectedRequestException;
import com.bes.enterprise.hc.core.http.nio.AsyncServerExchangeHandler;
import com.bes.enterprise.hc.core.http.nio.HandlerFactory;
import com.bes.enterprise.hc.core.http.nio.support.ImmediateResponseExchangeHandler;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import com.bes.enterprise.hc.core.util.Args;

public final class DefaultAsyncResponseExchangeHandlerFactory
implements HandlerFactory<AsyncServerExchangeHandler> {
    private final HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> mapper;
    private final Decorator<AsyncServerExchangeHandler> decorator;

    public DefaultAsyncResponseExchangeHandlerFactory(HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> mapper, Decorator<AsyncServerExchangeHandler> decorator) {
        this.mapper = Args.notNull(mapper, "Request handler mapper");
        this.decorator = decorator;
    }

    public DefaultAsyncResponseExchangeHandlerFactory(HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> mapper) {
        this(mapper, null);
    }

    private AsyncServerExchangeHandler createHandler(HttpRequest request, HttpContext context) throws HttpException {
        try {
            Supplier<AsyncServerExchangeHandler> supplier = this.mapper.resolve(request, context);
            return supplier != null ? supplier.get() : new ImmediateResponseExchangeHandler(404, "Resource not found");
        }
        catch (MisdirectedRequestException ex) {
            return new ImmediateResponseExchangeHandler(421, "Not authoritative");
        }
    }

    @Override
    public AsyncServerExchangeHandler create(HttpRequest request, HttpContext context) throws HttpException {
        AsyncServerExchangeHandler handler = this.createHandler(request, context);
        if (handler != null) {
            return this.decorator != null ? this.decorator.decorate(handler) : handler;
        }
        return null;
    }
}

