/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.support;

import com.bes.enterprise.hc.core.http.EntityDetails;
import com.bes.enterprise.hc.core.http.Header;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.HttpResponse;
import com.bes.enterprise.hc.core.http.message.BasicHttpResponse;
import com.bes.enterprise.hc.core.http.nio.AsyncResponseProducer;
import com.bes.enterprise.hc.core.http.nio.AsyncServerExchangeHandler;
import com.bes.enterprise.hc.core.http.nio.CapacityChannel;
import com.bes.enterprise.hc.core.http.nio.DataStreamChannel;
import com.bes.enterprise.hc.core.http.nio.ResponseChannel;
import com.bes.enterprise.hc.core.http.nio.entity.AsyncEntityProducers;
import com.bes.enterprise.hc.core.http.nio.support.BasicResponseProducer;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public final class ImmediateResponseExchangeHandler
implements AsyncServerExchangeHandler {
    private final AsyncResponseProducer responseProducer;

    public ImmediateResponseExchangeHandler(AsyncResponseProducer responseProducer) {
        this.responseProducer = Args.notNull(responseProducer, "Response producer");
    }

    public ImmediateResponseExchangeHandler(HttpResponse response, String message) {
        this(new BasicResponseProducer(response, AsyncEntityProducers.create(message)));
    }

    public ImmediateResponseExchangeHandler(int status, String message) {
        this(new BasicHttpResponse(status), message);
    }

    @Override
    public void handleRequest(HttpRequest request, EntityDetails entityDetails, ResponseChannel responseChannel, HttpContext context) throws HttpException, IOException {
        this.responseProducer.sendResponse(responseChannel, context);
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        capacityChannel.update(Integer.MAX_VALUE);
    }

    @Override
    public void consume(ByteBuffer src) throws IOException {
    }

    @Override
    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
    }

    @Override
    public int available() {
        return this.responseProducer.available();
    }

    @Override
    public void produce(DataStreamChannel channel) throws IOException {
        this.responseProducer.produce(channel);
    }

    @Override
    public void failed(Exception cause) {
        this.responseProducer.failed(cause);
        this.releaseResources();
    }

    @Override
    public void releaseResources() {
        this.responseProducer.releaseResources();
    }
}

