/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.support.classic;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.impl.nio.ExpandableBuffer;
import com.bes.enterprise.hc.core.util.Args;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@Contract(threading=ThreadingBehavior.SAFE)
abstract class AbstractSharedBuffer
extends ExpandableBuffer {
    final ReentrantLock lock;
    final Condition condition;
    volatile boolean endStream;
    volatile boolean aborted;

    public AbstractSharedBuffer(ReentrantLock lock, int initialBufferSize) {
        super(initialBufferSize);
        this.lock = Args.notNull(lock, "Lock");
        this.condition = lock.newCondition();
    }

    @Override
    public boolean hasData() {
        this.lock.lock();
        try {
            boolean bl = super.hasData();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int capacity() {
        this.lock.lock();
        try {
            int n2 = super.capacity();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int length() {
        this.lock.lock();
        try {
            int n2 = super.length();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void abort() {
        this.lock.lock();
        try {
            this.endStream = true;
            this.aborted = true;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        if (this.aborted) {
            return;
        }
        this.lock.lock();
        try {
            this.setInputMode();
            this.buffer().clear();
            this.endStream = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEndStream() {
        this.lock.lock();
        try {
            boolean bl = this.endStream && !super.hasData();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

