/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.support.classic;

import com.bes.enterprise.hc.core.http.nio.support.classic.ContentInputBuffer;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;
import java.io.InputStream;

public class ContentInputStream
extends InputStream {
    private final ContentInputBuffer buffer;

    public ContentInputStream(ContentInputBuffer buffer) {
        Args.notNull(buffer, "Input buffer");
        this.buffer = buffer;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.length();
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        return this.buffer.read(b2, off, len);
    }

    @Override
    public int read(byte[] b2) throws IOException {
        if (b2 == null) {
            return 0;
        }
        return this.buffer.read(b2, 0, b2.length);
    }

    @Override
    public int read() throws IOException {
        return this.buffer.read();
    }

    @Override
    public void close() throws IOException {
        byte[] tmp = new byte[1024];
        while (this.buffer.read(tmp, 0, tmp.length) >= 0) {
        }
        super.close();
    }
}

