/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.support.classic;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.nio.CapacityChannel;
import com.bes.enterprise.hc.core.http.nio.support.classic.AbstractSharedBuffer;
import com.bes.enterprise.hc.core.http.nio.support.classic.ContentInputBuffer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;

@Contract(threading=ThreadingBehavior.SAFE)
public final class SharedInputBuffer
extends AbstractSharedBuffer
implements ContentInputBuffer {
    private volatile CapacityChannel capacityChannel;

    public SharedInputBuffer(ReentrantLock lock, int initialBufferSize) {
        super(lock, initialBufferSize);
    }

    public SharedInputBuffer(int bufferSize) {
        super(new ReentrantLock(), bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(ByteBuffer src) {
        this.lock.lock();
        try {
            this.setInputMode();
            this.ensureAdjustedCapacity(this.buffer().position() + src.remaining());
            this.buffer().put(src);
            int remaining = this.buffer().remaining();
            this.condition.signalAll();
            int n2 = remaining;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.lock.lock();
        try {
            this.capacityChannel = capacityChannel;
            this.setInputMode();
            if (this.buffer().hasRemaining()) {
                capacityChannel.update(this.buffer().remaining());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void awaitInput() throws InterruptedIOException {
        if (!this.buffer().hasRemaining()) {
            this.setInputMode();
            while (this.buffer().position() == 0 && !this.endStream && !this.aborted) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException(ex.getMessage());
                }
            }
            this.setOutputMode();
        }
    }

    @Override
    public int read() throws IOException {
        this.lock.lock();
        try {
            this.setOutputMode();
            this.awaitInput();
            if (this.aborted) {
                int n2 = -1;
                return n2;
            }
            if (!this.buffer().hasRemaining() && this.endStream) {
                int n3 = -1;
                return n3;
            }
            int b2 = this.buffer().get() & 0xFF;
            if (!this.buffer().hasRemaining() && this.capacityChannel != null) {
                this.setInputMode();
                if (this.buffer().hasRemaining()) {
                    this.capacityChannel.update(this.buffer().remaining());
                }
            }
            int n4 = b2;
            return n4;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        this.lock.lock();
        try {
            this.setOutputMode();
            this.awaitInput();
            if (this.aborted) {
                int n2 = -1;
                return n2;
            }
            if (!this.buffer().hasRemaining() && this.endStream) {
                int n3 = -1;
                return n3;
            }
            int chunk = Math.min(this.buffer().remaining(), len);
            this.buffer().get(b2, off, chunk);
            if (!this.buffer().hasRemaining() && this.capacityChannel != null) {
                this.setInputMode();
                if (this.buffer().hasRemaining()) {
                    this.capacityChannel.update(this.buffer().remaining());
                }
            }
            int n4 = chunk;
            return n4;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void markEndStream() {
        if (this.endStream) {
            return;
        }
        this.lock.lock();
        try {
            if (!this.endStream) {
                this.endStream = true;
                this.capacityChannel = null;
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

