/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.protocol;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.EntityDetails;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.HttpRequestInterceptor;
import com.bes.enterprise.hc.core.http.Method;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (Method.CONNECT.isSame(method)) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            if (request.containsHeader("Upgrade")) {
                request.addHeader("Connection", "upgrade");
            } else {
                request.addHeader("Connection", "keep-alive");
            }
        }
    }
}

