/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.protocol;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.EntityDetails;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.HttpRequestInterceptor;
import com.bes.enterprise.hc.core.http.HttpVersion;
import com.bes.enterprise.hc.core.http.ProtocolVersion;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && entity != null) {
            ProtocolVersion ver = context.getProtocolVersion();
            if (entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

