/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.protocol;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.EntityDetails;
import com.bes.enterprise.hc.core.http.Header;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.HttpRequestInterceptor;
import com.bes.enterprise.hc.core.http.HttpVersion;
import com.bes.enterprise.hc.core.http.ProtocolException;
import com.bes.enterprise.hc.core.http.ProtocolVersion;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import com.bes.enterprise.hc.core.net.URIAuthority;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;
import java.net.URISyntaxException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestValidateHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Header header = request.getHeader("Host");
        if (header != null) {
            URIAuthority authority;
            try {
                authority = URIAuthority.create(header.getValue());
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException(ex.getMessage(), ex);
            }
            request.setAuthority(authority);
        } else {
            ProtocolVersion version;
            ProtocolVersion protocolVersion = version = request.getVersion() != null ? request.getVersion() : HttpVersion.HTTP_1_1;
            if (version.greaterEquals(HttpVersion.HTTP_1_1)) {
                throw new ProtocolException("Host header is absent");
            }
        }
    }
}

