/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.protocol;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.EntityDetails;
import com.bes.enterprise.hc.core.http.HeaderElement;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.HttpResponse;
import com.bes.enterprise.hc.core.http.HttpResponseInterceptor;
import com.bes.enterprise.hc.core.http.HttpVersion;
import com.bes.enterprise.hc.core.http.ProtocolVersion;
import com.bes.enterprise.hc.core.http.message.MessageSupport;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import com.bes.enterprise.hc.core.http.protocol.HttpCoreContext;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;
import java.util.Iterator;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseConnControl
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        Args.notNull(context, "HTTP context");
        int status = response.getCode();
        if (status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 503 || status == 501) {
            response.setHeader("Connection", "close");
            return;
        }
        if (!response.containsHeader("Connection")) {
            ProtocolVersion ver = context.getProtocolVersion();
            if (entity != null && entity.getContentLength() < 0L && ver.lessEquals(HttpVersion.HTTP_1_0)) {
                response.setHeader("Connection", "close");
            } else {
                HttpCoreContext coreContext = HttpCoreContext.adapt(context);
                HttpRequest request = coreContext.getRequest();
                boolean closeRequested = false;
                boolean keepAliveRequested = false;
                if (request != null) {
                    Iterator<HeaderElement> it = MessageSupport.iterate(request, "Connection");
                    while (it.hasNext()) {
                        HeaderElement he = it.next();
                        if (he.getName().equalsIgnoreCase("close")) {
                            closeRequested = true;
                            break;
                        }
                        if (!he.getName().equalsIgnoreCase("keep-alive")) continue;
                        keepAliveRequested = true;
                    }
                }
                if (closeRequested) {
                    response.addHeader("Connection", "close");
                } else if (response.containsHeader("Upgrade")) {
                    response.addHeader("Connection", "upgrade");
                } else if (keepAliveRequested) {
                    response.addHeader("Connection", "keep-alive");
                } else if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                    response.addHeader("Connection", "close");
                }
            }
        }
    }
}

