/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.pool;

import com.bes.enterprise.hc.core.annotation.Internal;
import com.bes.enterprise.hc.core.http.SocketModalCloseable;
import com.bes.enterprise.hc.core.io.CloseMode;
import com.bes.enterprise.hc.core.pool.DisposalCallback;
import com.bes.enterprise.hc.core.util.TimeValue;
import com.bes.enterprise.hc.core.util.Timeout;

@Internal
public final class DefaultDisposalCallback<T extends SocketModalCloseable>
implements DisposalCallback<T> {
    private static final Timeout DEFAULT_CLOSE_TIMEOUT = Timeout.ofSeconds(1L);

    @Override
    public void execute(SocketModalCloseable closeable, CloseMode closeMode) {
        Timeout socketTimeout = closeable.getSocketTimeout();
        if (socketTimeout == null || socketTimeout.compareTo(TimeValue.ZERO_MILLISECONDS) <= 0 || socketTimeout.compareTo(DEFAULT_CLOSE_TIMEOUT) > 0) {
            closeable.setSocketTimeout(DEFAULT_CLOSE_TIMEOUT);
        }
        closeable.close(closeMode);
    }
}

