/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.reactor;

import com.bes.enterprise.hc.core.concurrent.DefaultThreadFactory;
import com.bes.enterprise.hc.core.function.Callback;
import com.bes.enterprise.hc.core.function.Decorator;
import com.bes.enterprise.hc.core.io.CloseMode;
import com.bes.enterprise.hc.core.reactor.AbstractIOReactorBase;
import com.bes.enterprise.hc.core.reactor.IOEventHandlerFactory;
import com.bes.enterprise.hc.core.reactor.IOReactorConfig;
import com.bes.enterprise.hc.core.reactor.IOReactorStatus;
import com.bes.enterprise.hc.core.reactor.IOReactorWorker;
import com.bes.enterprise.hc.core.reactor.IOSession;
import com.bes.enterprise.hc.core.reactor.IOSessionListener;
import com.bes.enterprise.hc.core.reactor.IOWorkers;
import com.bes.enterprise.hc.core.reactor.MultiCoreIOReactor;
import com.bes.enterprise.hc.core.reactor.SingleCoreIOReactor;
import com.bes.enterprise.hc.core.util.Args;
import com.bes.enterprise.hc.core.util.TimeValue;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;

public class DefaultConnectingIOReactor
extends AbstractIOReactorBase {
    private final int workerCount;
    private final SingleCoreIOReactor[] workers;
    private final MultiCoreIOReactor ioReactor;
    private final IOWorkers.Selector workerSelector;
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory("I/O client dispatch", true);

    public DefaultConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, ThreadFactory threadFactory, Decorator<IOSession> ioSessionDecorator, Callback<Exception> exceptionCallback, IOSessionListener sessionListener, Callback<IOSession> sessionShutdownCallback) {
        Args.notNull(eventHandlerFactory, "Event handler factory");
        this.workerCount = ioReactorConfig != null ? ioReactorConfig.getIoThreadCount() : IOReactorConfig.DEFAULT.getIoThreadCount();
        this.workers = new SingleCoreIOReactor[this.workerCount];
        Thread[] threads = new Thread[this.workerCount];
        for (int i2 = 0; i2 < this.workers.length; ++i2) {
            SingleCoreIOReactor dispatcher;
            this.workers[i2] = dispatcher = new SingleCoreIOReactor(exceptionCallback, eventHandlerFactory, ioReactorConfig != null ? ioReactorConfig : IOReactorConfig.DEFAULT, ioSessionDecorator, sessionListener, sessionShutdownCallback);
            threads[i2] = (threadFactory != null ? threadFactory : THREAD_FACTORY).newThread(new IOReactorWorker(dispatcher));
        }
        this.ioReactor = new MultiCoreIOReactor(this.workers, threads);
        this.workerSelector = IOWorkers.newSelector(this.workers);
    }

    public DefaultConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig config, Callback<IOSession> sessionShutdownCallback) {
        this(eventHandlerFactory, config, null, null, null, null, sessionShutdownCallback);
    }

    public DefaultConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory) {
        this(eventHandlerFactory, null, null);
    }

    @Override
    public void start() {
        this.ioReactor.start();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    IOWorkers.Selector getWorkerSelector() {
        return this.workerSelector;
    }

    @Override
    public void initiateShutdown() {
        this.ioReactor.initiateShutdown();
    }

    @Override
    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        this.ioReactor.awaitShutdown(waitTime);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioReactor.close(closeMode);
    }

    @Override
    public void close() throws IOException {
        this.ioReactor.close();
    }
}

