/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.reactor;

import com.bes.enterprise.hc.core.concurrent.DefaultThreadFactory;
import com.bes.enterprise.hc.core.concurrent.FutureCallback;
import com.bes.enterprise.hc.core.function.Callback;
import com.bes.enterprise.hc.core.function.Decorator;
import com.bes.enterprise.hc.core.io.CloseMode;
import com.bes.enterprise.hc.core.reactor.AbstractIOReactorBase;
import com.bes.enterprise.hc.core.reactor.ChannelEntry;
import com.bes.enterprise.hc.core.reactor.ConnectionAcceptor;
import com.bes.enterprise.hc.core.reactor.IOEventHandlerFactory;
import com.bes.enterprise.hc.core.reactor.IOReactor;
import com.bes.enterprise.hc.core.reactor.IOReactorConfig;
import com.bes.enterprise.hc.core.reactor.IOReactorShutdownException;
import com.bes.enterprise.hc.core.reactor.IOReactorStatus;
import com.bes.enterprise.hc.core.reactor.IOReactorWorker;
import com.bes.enterprise.hc.core.reactor.IOSession;
import com.bes.enterprise.hc.core.reactor.IOSessionListener;
import com.bes.enterprise.hc.core.reactor.IOWorkers;
import com.bes.enterprise.hc.core.reactor.ListenerEndpoint;
import com.bes.enterprise.hc.core.reactor.MultiCoreIOReactor;
import com.bes.enterprise.hc.core.reactor.SingleCoreIOReactor;
import com.bes.enterprise.hc.core.reactor.SingleCoreListeningIOReactor;
import com.bes.enterprise.hc.core.util.Args;
import com.bes.enterprise.hc.core.util.TimeValue;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class DefaultListeningIOReactor
extends AbstractIOReactorBase
implements ConnectionAcceptor {
    private static final ThreadFactory DISPATCH_THREAD_FACTORY = new DefaultThreadFactory("I/O server dispatch", true);
    private static final ThreadFactory LISTENER_THREAD_FACTORY = new DefaultThreadFactory("I/O listener", true);
    private final int workerCount;
    private final SingleCoreIOReactor[] workers;
    private final SingleCoreListeningIOReactor listener;
    private final MultiCoreIOReactor ioReactor;
    private final IOWorkers.Selector workerSelector;

    public DefaultListeningIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, ThreadFactory dispatchThreadFactory, ThreadFactory listenerThreadFactory, Decorator<IOSession> ioSessionDecorator, Callback<Exception> exceptionCallback, IOSessionListener sessionListener, Callback<IOSession> sessionShutdownCallback) {
        Args.notNull(eventHandlerFactory, "Event handler factory");
        this.workerCount = ioReactorConfig != null ? ioReactorConfig.getIoThreadCount() : IOReactorConfig.DEFAULT.getIoThreadCount();
        this.workers = new SingleCoreIOReactor[this.workerCount];
        Thread[] threads = new Thread[this.workerCount + 1];
        for (int i2 = 0; i2 < this.workers.length; ++i2) {
            SingleCoreIOReactor dispatcher;
            this.workers[i2] = dispatcher = new SingleCoreIOReactor(exceptionCallback, eventHandlerFactory, ioReactorConfig != null ? ioReactorConfig : IOReactorConfig.DEFAULT, ioSessionDecorator, sessionListener, sessionShutdownCallback);
            threads[i2 + 1] = (dispatchThreadFactory != null ? dispatchThreadFactory : DISPATCH_THREAD_FACTORY).newThread(new IOReactorWorker(dispatcher));
        }
        IOReactor[] ioReactors = new IOReactor[this.workerCount + 1];
        System.arraycopy(this.workers, 0, ioReactors, 1, this.workerCount);
        this.listener = new SingleCoreListeningIOReactor(exceptionCallback, ioReactorConfig, new Callback<ChannelEntry>(){

            @Override
            public void execute(ChannelEntry entry) {
                DefaultListeningIOReactor.this.enqueueChannel(entry);
            }
        });
        ioReactors[0] = this.listener;
        threads[0] = (listenerThreadFactory != null ? listenerThreadFactory : LISTENER_THREAD_FACTORY).newThread(new IOReactorWorker(this.listener));
        this.ioReactor = new MultiCoreIOReactor(ioReactors, threads);
        this.workerSelector = IOWorkers.newSelector(this.workers);
    }

    public DefaultListeningIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig config, Callback<IOSession> sessionShutdownCallback) {
        this(eventHandlerFactory, config, null, null, null, null, null, sessionShutdownCallback);
    }

    public DefaultListeningIOReactor(IOEventHandlerFactory eventHandlerFactory) {
        this(eventHandlerFactory, null, null);
    }

    @Override
    public void start() {
        this.ioReactor.start();
    }

    public Future<ListenerEndpoint> listen(SocketAddress address, Object attachment, FutureCallback<ListenerEndpoint> callback) {
        return this.listener.listen(address, attachment, callback);
    }

    @Override
    public Future<ListenerEndpoint> listen(SocketAddress address, FutureCallback<ListenerEndpoint> callback) {
        return this.listen(address, null, callback);
    }

    public Future<ListenerEndpoint> listen(SocketAddress address) {
        return this.listen(address, null);
    }

    @Override
    public Set<ListenerEndpoint> getEndpoints() {
        return this.listener.getEndpoints();
    }

    @Override
    public void pause() throws IOException {
        this.listener.pause();
    }

    @Override
    public void resume() throws IOException {
        this.listener.resume();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    IOWorkers.Selector getWorkerSelector() {
        return this.workerSelector;
    }

    private void enqueueChannel(ChannelEntry entry) {
        try {
            this.workerSelector.next().enqueueChannel(entry);
        }
        catch (IOReactorShutdownException ex) {
            this.initiateShutdown();
        }
    }

    @Override
    public void initiateShutdown() {
        this.ioReactor.initiateShutdown();
    }

    @Override
    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        this.ioReactor.awaitShutdown(waitTime);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioReactor.close(closeMode);
    }

    @Override
    public void close() throws IOException {
        this.ioReactor.close();
    }
}

