/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.logging;

import com.bes.enterprise.appserver.common.util.ServerLayoutConstants;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.miniparser.SystemPropertyValueTranslator;
import com.bes.enterprise.config.provider.ConfigProviderGlobals;
import com.bes.enterprise.logging.AsyncFileHandler;
import com.bes.enterprise.logging.BESLogFormatter;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class AsyncFileHandlerEx
extends AsyncFileHandler {
    private DomTemplate logService;
    private SimpleDateFormat fileDateFormatter;
    private List<String> rotationDates;
    private volatile String lastDate;
    private AtomicInteger writtenBytes;
    private String logFilePath;

    public AsyncFileHandlerEx() {
        this(null, null, null);
    }

    public AsyncFileHandlerEx(String directory, String prefix, String suffix) {
        super(directory, prefix, suffix);
    }

    @Override
    public void configure() {
        DomTemplate server = (DomTemplate)ConfigProviderGlobals.getGlobalItem("rootConfig");
        if (server == null) {
            throw new RuntimeException("Log service configuration is not provided!");
        }
        this.logService = server.getElement("log-service");
        this.fileDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss", Locale.US);
        if (this.logService.getElements("property") != null) {
            for (DomTemplate property : this.logService.getElements("property")) {
                if (!"fileDateFormat".equals(property.getAttribute("name")) || property.getAttribute("value") == null || property.getAttribute("value").isEmpty()) continue;
                this.fileDateFormatter = new SimpleDateFormat(property.getAttribute("value"), Locale.US);
                break;
            }
        }
        this.lastDate = this.fileDateFormatter.format(System.currentTimeMillis());
        this.logFilePath = SystemPropertyValueTranslator.getInstance().getTranslatedValue(this.logService.getAttribute("log-file"));
        this.writtenBytes = new AtomicInteger((int)new File(this.logFilePath).length());
        this.setLevel(Level.ALL);
        if (this.logService.getAttribute("log-filter") != null) {
            try {
                this.setFilter((Filter)this.getClass().getClassLoader().loadClass(this.logService.getAttribute("log-filter")).newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setFormatter(new BESLogFormatter());
        this.setErrorManager(new ErrorManager());
        this.rotatable = Boolean.parseBoolean(this.logService.getAttribute("rotation-enabled"));
        File dir = new File(this.logFilePath);
        if (!dir.isAbsolute()) {
            this.logFilePath = System.getProperty(ServerLayoutConstants.INSTANCE_ROOT_PROPERTY) + "/logs/" + this.logFilePath;
            dir = new File(this.logFilePath);
        }
        this.directory = dir.getParent();
        String fileName = dir.getName();
        if (fileName.contains(".")) {
            this.prefix = fileName.substring(0, fileName.lastIndexOf("."));
            this.suffix = fileName.substring(fileName.lastIndexOf("."));
        } else {
            this.prefix = fileName;
            this.suffix = "";
        }
    }

    @Override
    protected void openWriter() {
        if (this.rotatable) {
            this.handleMaxRotationFiles();
            if (this.lastDate == null || this.lastDate.isEmpty()) {
                this.lastDate = this.fileDateFormatter.format(System.currentTimeMillis());
            } else if (!this.rotationDates.contains(this.lastDate)) {
                this.rotationDates.add(this.lastDate);
            }
        }
        super.openWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void publishInternal(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        String result = null;
        try {
            result = this.getFormatter().format(record);
        }
        catch (Exception e2) {
            this.reportError(null, e2, 5);
            return;
        }
        int logLength = result.getBytes().length;
        int roationTime = Integer.parseInt(this.logService.getAttribute("rotation-time"));
        int rotationSize = Integer.parseInt(this.logService.getAttribute("rotation-size"));
        this.writerLock.readLock().lock();
        try {
            if (this.rotatable) {
                long lastTime = 0L;
                long nowTime = 0L;
                try {
                    lastTime = this.fileDateFormatter.parse(this.lastDate).getTime();
                    nowTime = this.fileDateFormatter.parse(this.fileDateFormatter.format(System.currentTimeMillis())).getTime();
                }
                catch (Exception e3) {
                    this.reportError(null, e3, 1);
                    this.writerLock.readLock().unlock();
                    return;
                }
                if (roationTime != 0 && nowTime - lastTime >= (long)(roationTime * 1000 * 60) || roationTime == 0 && this.writtenBytes.intValue() >= rotationSize) {
                    this.writerLock.readLock().unlock();
                    this.writerLock.writeLock().lock();
                    try {
                        if (roationTime != 0 && nowTime - lastTime >= (long)(roationTime * 1000 * 60) || roationTime == 0 && this.writtenBytes.intValue() >= rotationSize) {
                            this.close(true, this.lastDate);
                            this.writtenBytes.set(0);
                            this.openWriter();
                            this.lastDate = this.fileDateFormatter.format(nowTime);
                        }
                    }
                    finally {
                        this.writerLock.readLock().lock();
                        this.writerLock.writeLock().unlock();
                    }
                }
            }
            try {
                if (this.writer != null) {
                    this.writer.write(result);
                    this.writtenBytes.addAndGet(logLength);
                    if (this.bufferSize < 0) {
                        this.writer.flush();
                    }
                } else {
                    this.reportError("FileHandler is closed or not yet initialized, unable to log [" + result + "]", null, 1);
                }
            }
            catch (Exception e4) {
                this.reportError(null, e4, 1);
                this.writerLock.readLock().unlock();
                return;
            }
        }
        finally {
            this.writerLock.readLock().unlock();
        }
    }

    private void close(boolean rename, String date) {
        super.closeWriter();
        if (rename) {
            File dir = new File(this.directory);
            if (!dir.mkdirs() && !dir.isDirectory()) {
                this.reportError("Unable to create [" + dir + "]", null, 4);
                return;
            }
            File newLogFile = new File(dir.getAbsoluteFile(), this.prefix + (this.rotatable ? date : "") + this.suffix);
            File parent = newLogFile.getParentFile();
            if (!parent.mkdirs() && !parent.isDirectory()) {
                this.reportError("Unable to create [" + parent + "]", null, 4);
                return;
            }
            if (!newLogFile.exists()) {
                try {
                    if (!new File(this.logFilePath).renameTo(newLogFile)) {
                        this.reportError("Unable to rename [" + newLogFile.getName() + "]", null, 4);
                    }
                }
                catch (Exception e2) {
                    this.reportError("Unable to rename [" + newLogFile.getName() + "]", e2, 4);
                }
            } else {
                this.reportError("Unable to rename [" + newLogFile.getName() + "]", null, 4);
            }
        }
    }

    private static String absoluteConfigFile(String configFile) {
        File file = new File(configFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("com.bes.instanceRoot"), configFile);
        }
        return file.getAbsolutePath();
    }

    private String getRotationDate(String fileName) {
        if (!fileName.startsWith(this.prefix) || !fileName.endsWith(this.suffix)) {
            return null;
        }
        String date = fileName.substring(this.prefix.length());
        if (this.suffix.length() > 0) {
            date = fileName.substring(this.prefix.length(), fileName.indexOf(this.suffix));
        }
        try {
            this.fileDateFormatter.setLenient(false);
            this.fileDateFormatter.parse(date);
        }
        catch (ParseException e2) {
            return null;
        }
        if (date.length() != this.fileDateFormatter.toPattern().length()) {
            return null;
        }
        return date;
    }

    private void handleMaxRotationFiles() {
        this.initRotationFiles();
        int maxFiles = Integer.parseInt(this.logService.getAttribute("max-history-files"));
        if (this.lastDate == null || this.rotationDates.contains(this.lastDate)) {
            ++maxFiles;
        }
        while (this.rotationDates.size() >= maxFiles) {
            String earliest = this.rotationDates.remove(0);
            File file = this.getRotationFile(earliest);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    private void initRotationFiles() {
        File[] files;
        if (this.rotationDates != null) {
            return;
        }
        this.rotationDates = new ArrayList<String>();
        File parent = new File(this.directory);
        if (parent != null && parent.exists() && (files = parent.listFiles()) != null) {
            for (File file : files) {
                String date = this.getRotationDate(file.getName());
                if (date == null) continue;
                this.rotationDates.add(date);
            }
        }
    }

    public File getRotationFile(String date) {
        return new File(this.directory, this.prefix + (this.rotatable ? date : "") + this.suffix);
    }
}

