/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.security.jndi;

import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.security.jndi.JndiCheckBean;
import com.bes.enterprise.security.jndi.JndiCheckList;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class JndiInjectionChecker {
    protected static final Logger _logger = Logger.getLogger(JndiInjectionChecker.class.getName());
    private static final String JNDI_INJECTION_CHECKER_ENABLED = "com.bes.enterprise.security.jndi.JndiInjectionChecker.enabled";
    private static final String BLACK_LIST_FILE = "com.bes.enterprise.security.jndi.JndiInjectionChecker.blacklistFile";
    private static final String WHITE_LIST_FILE = "com.bes.enterprise.security.jndi.JndiInjectionChecker.whitelistFile";
    private static final String DEFAULT_BLACK_LIST_FILE = "jndi/jndiBlackList";
    private static final String DEFAULT_WHITE_LIST_FILE = "jndi/jndiWhiteList";
    private static final boolean enabled = Boolean.parseBoolean(System.getProperty("com.bes.enterprise.security.jndi.JndiInjectionChecker.enabled", "true"));
    private static final Map<String, List<JndiCheckList>> blackList = new HashMap<String, List<JndiCheckList>>();
    private static final Map<String, List<JndiCheckList>> whiteList = new HashMap<String, List<JndiCheckList>>();
    private static volatile boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (initialized) {
            return;
        }
        Class<JndiInjectionChecker> clazz = JndiInjectionChecker.class;
        synchronized (JndiInjectionChecker.class) {
            if (initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (enabled) {
                String blackListFile = System.getProperty(BLACK_LIST_FILE);
                if (blackListFile == null) {
                    blackListFile = DEFAULT_BLACK_LIST_FILE;
                }
                JndiInjectionChecker.loadConfig(blackListFile, blackList);
                String whiteListFile = System.getProperty(WHITE_LIST_FILE);
                if (whiteListFile == null) {
                    whiteListFile = DEFAULT_WHITE_LIST_FILE;
                }
                JndiInjectionChecker.loadConfig(whiteListFile, whiteList);
            }
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void allow(JndiCheckBean checkBean) throws NamingException {
        if (!initialized) {
            JndiInjectionChecker.init();
        }
        if (!enabled) {
            return;
        }
        JndiCheckResult checkResult = JndiInjectionChecker.allowJndiReferenceBind(checkBean);
        if (!checkResult.getResult().booleanValue()) {
            if (checkResult.getCheckList().isAllProperty()) {
                throw new NamingException(String.format("Class %s is in blacklist!", checkResult.getCheckList().getClassName()));
            }
            throw new NamingException(String.format("The %s object with %s '%s' is in blacklist!", checkResult.getCheckList().getClassName(), checkResult.getCheckList().getPropertyName(), checkResult.getCheckPropertyValue()));
        }
    }

    private static JndiCheckResult allowJndiReferenceBind(JndiCheckBean checkBean) {
        List<JndiCheckList> jndiCheckLists;
        JndiCheckResult checkResult = new JndiCheckResult();
        if (whiteList.size() > 0 && (jndiCheckLists = whiteList.get(checkBean.getClazz().getName())) != null) {
            for (JndiCheckList checkItem : jndiCheckLists) {
                if (checkItem.isAllProperty()) {
                    checkResult.setResult(Boolean.TRUE);
                    return checkResult;
                }
                if (!JndiInjectionChecker.checkReferenceMatches(checkBean, checkItem, checkResult).booleanValue()) continue;
                checkResult.setResult(Boolean.TRUE);
                return checkResult;
            }
        }
        if (blackList.size() > 0 && (jndiCheckLists = blackList.get(checkBean.getClazz().getName())) != null) {
            for (JndiCheckList checkItem : jndiCheckLists) {
                if (checkItem.isAllProperty()) {
                    checkResult.setCheckList(checkItem);
                    checkResult.setResult(Boolean.FALSE);
                    return checkResult;
                }
                if (!JndiInjectionChecker.checkReferenceMatches(checkBean, checkItem, checkResult).booleanValue()) continue;
                checkResult.setResult(Boolean.FALSE);
                return checkResult;
            }
        }
        checkResult.setResult(Boolean.TRUE);
        return checkResult;
    }

    private static boolean matches(String className, String prefix) {
        return prefix.endsWith(".*") ? className.startsWith(prefix = prefix.substring(0, prefix.length() - 2)) : (prefix.endsWith("*") ? className.startsWith(prefix = prefix.substring(0, prefix.length() - 1)) : className.equals(prefix));
    }

    private static Boolean checkReferenceMatches(JndiCheckBean checkBean, JndiCheckList checkItem, JndiCheckResult checkResult) {
        block3: {
            block2: {
                if (!StringUtils.isEmpty((String)checkBean.getPropertyName())) break block2;
                String checkValue = ReflectionUtil.getFieldValue(checkBean.getCheckObj(), checkItem);
                for (String propertyValue : checkItem.getPropertyValue()) {
                    if (!JndiInjectionChecker.matches(checkValue, propertyValue)) continue;
                    checkResult.setCheckList(checkItem);
                    checkResult.setCheckPropertyValue(checkValue);
                    return Boolean.TRUE;
                }
                break block3;
            }
            if (!checkItem.getPropertyName().equals(checkBean.getPropertyName())) break block3;
            for (String propertyValue : checkItem.getPropertyValue()) {
                if (!JndiInjectionChecker.matches(StringUtils.nvl((Object)checkBean.getPropertyValue()), propertyValue)) continue;
                checkResult.setCheckList(checkItem);
                checkResult.setCheckPropertyValue(checkBean.getPropertyValue());
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadConfig(String configFile, Map<String, List<JndiCheckList>> nameList) {
        InputStream in = null;
        BufferedReader reader = null;
        try {
            String line;
            in = JndiInjectionChecker.getInputStream(configFile);
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.startsWith("//")) continue;
                String[] split = line.split("=");
                if (split.length == 1) {
                    nameList.put(split[0], Collections.singletonList(new JndiCheckList(split[0])));
                    continue;
                }
                if (split.length != 2) continue;
                int firstBrackets = split[0].indexOf("[@");
                int lastBrackets = split[0].indexOf(93, firstBrackets);
                if (firstBrackets < 0 || lastBrackets < 0 || lastBrackets < firstBrackets) continue;
                String className = split[0].substring(0, firstBrackets).trim();
                String propertyName = split[0].substring(firstBrackets + 2, lastBrackets).trim();
                List<JndiCheckList> jndiCheckLists = nameList.get(className);
                if (jndiCheckLists != null) {
                    jndiCheckLists.add(new JndiCheckList(className, propertyName, new HashSet<String>(Arrays.asList(split[1].trim().split(",")))));
                    continue;
                }
                jndiCheckLists = new ArrayList<JndiCheckList>();
                jndiCheckLists.add(new JndiCheckList(className, propertyName, new HashSet<String>(Arrays.asList(split[1].trim().split(",")))));
                nameList.put(className, jndiCheckLists);
            }
        }
        catch (IOException ex) {
            _logger.warning(ex.getClass().getName() + ":" + ex.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static InputStream getInputStream(String configFile) throws IOException {
        ClassLoader loader = JndiInjectionChecker.class.getClassLoader();
        InputStream in = loader.getResourceAsStream(configFile);
        if (in != null) {
            return in;
        }
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader != loader && (in = contextLoader.getResourceAsStream(configFile)) != null) {
            return in;
        }
        throw new IOException("Could not read config file: " + configFile + "!");
    }

    private static class JndiCheckResult {
        private Boolean result;
        private JndiCheckList checkList;
        private String checkPropertyValue;

        private JndiCheckResult() {
        }

        public Boolean getResult() {
            return this.result;
        }

        public void setResult(Boolean result) {
            this.result = result;
        }

        public JndiCheckList getCheckList() {
            return this.checkList;
        }

        public void setCheckList(JndiCheckList checkList) {
            this.checkList = checkList;
        }

        public String getCheckPropertyValue() {
            return this.checkPropertyValue;
        }

        public void setCheckPropertyValue(String checkPropertyValue) {
            this.checkPropertyValue = checkPropertyValue;
        }
    }

    private static class ReflectionUtil {
        private ReflectionUtil() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getFieldValue(Object obj, JndiCheckList checkItem) {
            try {
                PropertyDescriptor[] propertyDescriptors;
                try {
                    if (checkItem.getPropertyGetMethod() != null) {
                        return String.valueOf(checkItem.getPropertyGetMethod().invoke(obj, new Object[0]));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors = Introspector.getBeanInfo(obj.getClass()).getPropertyDescriptors()) {
                    if (!propertyDescriptor.getName().equals(checkItem.getPropertyName())) continue;
                    Method method = propertyDescriptor.getReadMethod();
                    checkItem.setPropertyGetMethod(method);
                    return String.valueOf(method.invoke(obj, new Object[0]));
                }
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException propertyDescriptors) {
                // empty catch block
            }
            Field field = null;
            Boolean oldAccessible = null;
            try {
                field = obj.getClass().getDeclaredField(checkItem.getPropertyName());
                oldAccessible = field.isAccessible();
                field.setAccessible(true);
                String string = String.valueOf(field.get(obj));
                return string;
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            }
            finally {
                if (oldAccessible != null) {
                    field.setAccessible(oldAccessible);
                }
            }
            return "";
        }
    }
}

