/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.security.jndi;

import com.bes.enterprise.security.jndi.JndiCheckBean;
import com.bes.enterprise.security.jndi.JndiInjectionChecker;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;

public class NamingManagerEnhancer {
    public static Object getObjectInstance(Object refInfo, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        NamingManagerEnhancer.checkReferenceObjectSecurity(refInfo);
        return NamingManager.getObjectInstance(refInfo, name, nameCtx, environment);
    }

    public static void checkReferenceObjectSecurity(Object refInfo) throws NamingException {
        if (refInfo == null) {
            return;
        }
        if (refInfo instanceof Reference) {
            Reference reference = (Reference)refInfo;
            JndiInjectionChecker.allow(new JndiCheckBean(Reference.class, "className", reference.getClassName()));
            JndiInjectionChecker.allow(new JndiCheckBean(Reference.class, "classFactory", reference.getFactoryClassName()));
        } else if (refInfo instanceof Referenceable) {
            Referenceable reference = (Referenceable)refInfo;
            if (reference.getReference() != null) {
                JndiInjectionChecker.allow(new JndiCheckBean(Reference.class, "className", reference.getReference().getClassName()));
                JndiInjectionChecker.allow(new JndiCheckBean(Reference.class, "classFactory", reference.getReference().getFactoryClassName()));
            }
        } else {
            JndiInjectionChecker.allow(new JndiCheckBean(refInfo));
        }
    }
}

