/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.server.bootstrap;

import com.bes.enterprise.appserver.common.util.ServerLayoutConstants;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class ASMain {
    public static void main(String[] args) throws Exception {
        String installRootPath = System.getProperty(ServerLayoutConstants.INSTALL_ROOT_PROPERTY);
        if (installRootPath == null) {
            File jarLocation = ASMain.jarLocatation(ASMain.class);
            installRootPath = jarLocation.getParent();
            System.setProperty(ServerLayoutConstants.INSTALL_ROOT_PROPERTY, installRootPath);
        }
        System.setProperty("bes.base", installRootPath);
        System.setProperty("bes.home", installRootPath);
        File installRoot = new File(installRootPath);
        ClassLoader configProviderClasslaoder = null;
        try {
            configProviderClasslaoder = ASMain.buildConfigProviderClassLoader(installRoot);
            Thread.currentThread().setContextClassLoader(configProviderClasslaoder);
        }
        catch (MalformedURLException mlfEx) {
            mlfEx.printStackTrace();
            System.out.println("Failure to create config provider classloader!");
            System.exit(1);
        }
        String logManager = System.getProperty(ServerLayoutConstants.LOGGING_MANAGER_PROP);
        if (logManager == null) {
            System.setProperty(ServerLayoutConstants.LOGGING_MANAGER_PROP, "com.bes.enterprise.logging.BESLogManager");
        }
        try {
            Thread.currentThread().setContextClassLoader(configProviderClasslaoder);
            Class<?> serverMainClass = configProviderClasslaoder.loadClass("com.bes.enterprise.server.builder.BESAssembler");
            Method mainMethod = serverMainClass.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (InvocationTargetException inVx) {
            Throwable th = inVx.getTargetException();
            th.printStackTrace();
            System.out.println("Failure to launch server!");
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Failure to launch server!");
            System.exit(1);
        }
    }

    private static ClassLoader buildConfigProviderClassLoader(File installRootDir) throws MalformedURLException {
        File[] libJars;
        ArrayList<URL> urls = new ArrayList<URL>();
        FileFilter jarFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".jar");
            }
        };
        File libDir = new File(installRootDir, "lib");
        for (File jarFile : libJars = libDir.listFiles(jarFileFilter)) {
            urls.add(jarFile.toURI().toURL());
        }
        File pluginJarsDir = new File(installRootDir, "plugins");
        if (pluginJarsDir.exists()) {
            File[] pluginJars;
            for (File jarFile : pluginJars = pluginJarsDir.listFiles(jarFileFilter)) {
                urls.add(jarFile.toURI().toURL());
            }
        }
        URLClassLoader urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ClassLoader.getSystemClassLoader());
        return urlClassLoader;
    }

    private static File jarLocatation(Class clazz) {
        String resourceName = clazz.getName().replace(".", "/") + ".class";
        URL resource = clazz.getClassLoader().getResource(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("Cannot get install path from " + clazz + " class location!");
        }
        if (resource.getProtocol().equals("jar")) {
            try {
                JarURLConnection c2 = (JarURLConnection)resource.openConnection();
                URL jarFile = c2.getJarFileURL();
                try {
                    return new File(jarFile.toURI());
                }
                catch (URISyntaxException e2) {
                    return new File(jarFile.getPath());
                }
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot open jar file " + resource + "!", ex);
            }
        }
        throw new IllegalArgumentException("Don't support packaging " + resource + "!");
    }
}

