/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.server.builder;

import com.bes.enterprise.config.miniparser.ConfigBindingException;
import com.bes.enterprise.web.util.IntrospectionUtils;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.LifecycleListener;

public class LifecycleListenerCreateHelper {
    private final String className;
    private final String engineConfigClass;
    private Container parentContainer;

    public LifecycleListenerCreateHelper(String className, String engineConfigClass) {
        this.className = className;
        this.engineConfigClass = engineConfigClass;
    }

    public void setParentContainer(Container parentContainer) {
        this.parentContainer = parentContainer;
    }

    public String getClassName() {
        return this.className;
    }

    public LifecycleListener createConfigListener(Object configBean) {
        try {
            String configClass;
            String realClassName = null;
            String value = (String)IntrospectionUtils.getProperty(configBean, this.engineConfigClass);
            if (value != null) {
                realClassName = value;
            }
            if (this.parentContainer != null && realClassName == null && (configClass = (String)IntrospectionUtils.getProperty(this.parentContainer, this.engineConfigClass)) != null && configClass.length() > 0) {
                realClassName = configClass;
            }
            if (realClassName == null) {
                realClassName = this.getClassName();
            }
            Class<?> clazz = Class.forName(realClassName);
            LifecycleListener engineConfigListener = (LifecycleListener)clazz.newInstance();
            return engineConfigListener;
        }
        catch (InstantiationException ex) {
            throw new ConfigBindingException("Failure to instantiate listener " + this.className + ".", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigBindingException("Failure to instantiate listener " + this.className + ".", ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigBindingException("Failure to instantiate listener " + this.className + ".", ex);
        }
    }
}

