/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.server.builder;

import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.context.ContextHolder;
import com.bes.enterprise.context.ServerContextImpl;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.CloudWebContainer;
import com.bes.enterprise.webtier.Server;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class WebModuleBuilder {
    protected Log log = LogFactory.getLog(WebModuleBuilder.class.getName());
    private ClassLoader classLoader;
    private ClassLoader bcsClassLoader;
    private boolean useContextClassLoader;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBcsClassLoader(ClassLoader classLoader) {
        this.bcsClassLoader = classLoader;
    }

    public boolean isUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean useContextClassLoader) {
        this.useContextClassLoader = useContextClassLoader;
    }

    public Set<String> getExcludes() {
        return Collections.emptySet();
    }

    public Set<String> getFakeAttributes() {
        HashSet<String> fakeAttributeNames = new HashSet<String>();
        fakeAttributeNames.add("class-name");
        return Collections.unmodifiableSet(fakeAttributeNames);
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        return this.getClass().getClassLoader();
    }

    public Server buildWebContainer(DomTemplate serverSB) {
        ServerContextImpl context = new ServerContextImpl(serverSB);
        context.setCommonClassLoader(this.getClassLoader().getParent());
        context.setSharedClassLoader(this.getClassLoader());
        context.setBcsClassLoader(this.bcsClassLoader);
        ContextHolder.setServerContext(context);
        return CloudWebContainer.createInstance(context).getServer();
    }
}

