/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web;

import com.bes.enterprise.appserver.common.logging.LoggingOutputStream;
import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.miniparser.SystemPropertyValueTranslator;
import com.bes.enterprise.context.ServerContext;
import com.bes.enterprise.web.EmbeddedWebContainer;
import com.bes.enterprise.web.VirtualHost;
import com.bes.enterprise.web.util.BeanInspectUtils;
import com.bes.enterprise.web.util.IntrospectionUtils;
import com.bes.enterprise.web.util.descriptor.web.ContextEjb;
import com.bes.enterprise.web.util.descriptor.web.ContextEnvironment;
import com.bes.enterprise.web.util.descriptor.web.ContextLocalEjb;
import com.bes.enterprise.web.util.descriptor.web.ContextResource;
import com.bes.enterprise.web.util.descriptor.web.ContextResourceEnvRef;
import com.bes.enterprise.web.util.descriptor.web.ContextResourceLink;
import com.bes.enterprise.web.util.descriptor.web.ContextService;
import com.bes.enterprise.web.util.descriptor.web.ContextTransaction;
import com.bes.enterprise.web.util.descriptor.web.MessageDestinationRef;
import com.bes.enterprise.webtier.Executor;
import com.bes.enterprise.webtier.Realm;
import com.bes.enterprise.webtier.Server;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.deploy.NamingResourcesImpl;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BESWebContainer {
    protected static final Logger _logger = Logger.getLogger(BESWebContainer.class.getName());
    private static final String timeBetweenEvictionRunsMillisUpper = System.getProperty("com.bes.enterprise.jdbc.timeBetweenEvictionRunsMillis.UpperLimit", "60000");
    protected static final String hotDeployDirectory = System.getProperty("com.bes.installRoot") + "/hotdeploy";
    protected static final int hotdeployCheckInterval = Integer.parseInt(System.getProperty("com.bes.enterprise.web.hotDeployCheckInterval", "5000"));
    protected static BESWebContainer webContainer;
    protected final ServerContext context;
    protected EmbeddedWebContainer _embedded = null;
    private static SystemPropertyValueTranslator translator;
    private static final boolean outAndErrNotRedirect;
    private static final boolean omitOutAndErr;

    protected BESWebContainer(String id, ServerContext context) {
        this.initStdLog();
        this.context = context;
        this._embedded = new EmbeddedWebContainer(context, this);
        this._embedded.setName("com.bes.Service");
    }

    protected void initStdLog() {
        if (!outAndErrNotRedirect) {
            if (!omitOutAndErr) {
                LoggingOutputStream los;
                Logger _ologger = Logger.getLogger("javax.enterprise.system.std");
                LoggingOutputStream loggingOutputStream = los = new LoggingOutputStream(_ologger, Level.INFO);
                loggingOutputStream.getClass();
                LoggingOutputStream.LoggingPrintStream pout = new LoggingOutputStream.LoggingPrintStream(loggingOutputStream, (ByteArrayOutputStream)los);
                System.setOut((PrintStream)pout);
                Logger _elogger = Logger.getLogger("javax.enterprise.system.std");
                LoggingOutputStream loggingOutputStream2 = los = new LoggingOutputStream(_elogger, Level.SEVERE);
                loggingOutputStream2.getClass();
                LoggingOutputStream.LoggingPrintStream perr = new LoggingOutputStream.LoggingPrintStream(loggingOutputStream2, (ByteArrayOutputStream)los);
                System.setErr((PrintStream)perr);
            } else {
                System.setOut((PrintStream)LoggingOutputStream.NullPrintStream.instance);
                System.setErr((PrintStream)LoggingOutputStream.NullPrintStream.instance);
            }
        }
    }

    protected void init() {
    }

    public Server getServer() {
        return this._embedded.getServer();
    }

    public VirtualHost createVS(String vsID, DomTemplate vsBean, String docroot, String logFile) {
        VirtualHost vs = (VirtualHost)this._embedded.createHost(vsID, vsBean, docroot);
        vs.configureVirtualServerState();
        vs.configureRemoteAddressFilterValve();
        vs.configureRemoteHostFilterValve();
        vs.configureSSOValve();
        vs.configureOtherValves(this.context);
        vs.configureErrorReportValve(this.context);
        return vs;
    }

    protected void setExecutor(Connector con, Executor ex) throws Exception {
        Method m2 = IntrospectionUtils.findMethod(con.getProtocolHandler().getClass(), "setExecutor", new Class[]{java.util.concurrent.Executor.class});
        if (m2 != null) {
            m2.invoke((Object)con.getProtocolHandler(), ex);
        } else if (_logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, "Connector [" + con + "] does not support external executors. Method setExecutor(java.util.concurrent.Executor) not found.");
        }
    }

    protected void addRealm(Realm realm, Realm childRealm) throws Exception {
        Method m2 = IntrospectionUtils.findMethod(realm.getClass(), "addRealm", new Class[]{Realm.class});
        if (m2 != null) {
            m2.invoke((Object)realm, childRealm);
        } else if (_logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, "Realm [" + realm + "] does not support nest Realms. Method addRealm(com.bes.enterprise.webtier.Realm) not found.");
        }
    }

    public void createResources() {
        List<DomTemplate> jdbcResources;
        DomTemplate resources;
        ContextResource contextResource;
        NamingResourcesImpl namingResources = new NamingResourcesImpl();
        DomTemplate namingService = this.context.getConfigBean().getElement("naming-service");
        if (namingService != null) {
            List<DomTemplate> jndiResources = namingService.getElements("jndi-resource");
            for (DomTemplate jndiResource : jndiResources) {
                String resourceType = jndiResource.getAttribute("resource-type");
                String pathnameValue = translator.getTranslatedValue(jndiResource.getAttribute("pathname"));
                if ("resource".equals(resourceType)) {
                    contextResource = new ContextResource();
                    BeanInspectUtils.transmitProperties((Object)contextResource, jndiResource);
                    BeanInspectUtils.transmitProperty(contextResource, "pathname", pathnameValue);
                    namingResources.addResource(contextResource);
                    continue;
                }
                if ("ejb".equals(resourceType)) {
                    ContextEjb contextEjb = new ContextEjb();
                    BeanInspectUtils.transmitProperties((Object)contextEjb, jndiResource);
                    BeanInspectUtils.transmitProperty(contextEjb, "pathname", pathnameValue);
                    namingResources.addEjb(contextEjb);
                    continue;
                }
                if ("local-ejb".equals(resourceType)) {
                    ContextLocalEjb contextLocalEjb = new ContextLocalEjb();
                    BeanInspectUtils.transmitProperties((Object)contextLocalEjb, jndiResource);
                    BeanInspectUtils.transmitProperty(contextLocalEjb, "pathname", pathnameValue);
                    namingResources.addLocalEjb(contextLocalEjb);
                    continue;
                }
                if ("environment".equals(resourceType)) {
                    ContextEnvironment contextEnviroment = new ContextEnvironment();
                    BeanInspectUtils.transmitProperties((Object)contextEnviroment, jndiResource);
                    BeanInspectUtils.transmitProperty(contextEnviroment, "pathname", pathnameValue);
                    namingResources.addEnvironment(contextEnviroment);
                    continue;
                }
                if ("resource-env-ref".equals(resourceType)) {
                    ContextResourceEnvRef contextResourceEnvRef = new ContextResourceEnvRef();
                    BeanInspectUtils.transmitProperties((Object)contextResourceEnvRef, jndiResource);
                    BeanInspectUtils.transmitProperty(contextResourceEnvRef, "pathname", pathnameValue);
                    namingResources.addResourceEnvRef(contextResourceEnvRef);
                    continue;
                }
                if ("resource-link".equals(resourceType)) {
                    ContextResourceLink contextResourceLink = new ContextResourceLink();
                    BeanInspectUtils.transmitProperties((Object)contextResourceLink, jndiResource);
                    BeanInspectUtils.transmitProperty(contextResourceLink, "pathname", pathnameValue);
                    namingResources.addResourceLink(contextResourceLink);
                    continue;
                }
                if ("service-ref".equals(resourceType)) {
                    ContextService contextService = new ContextService();
                    BeanInspectUtils.transmitProperties((Object)contextService, jndiResource);
                    BeanInspectUtils.transmitProperty(contextService, "pathname", pathnameValue);
                    namingResources.addService(contextService);
                    continue;
                }
                if ("message-destination-ref".equals(resourceType)) {
                    MessageDestinationRef messageDestinationRef = new MessageDestinationRef();
                    BeanInspectUtils.transmitProperties((Object)messageDestinationRef, jndiResource);
                    BeanInspectUtils.transmitProperty(messageDestinationRef, "pathname", pathnameValue);
                    namingResources.addMessageDestinationRef(messageDestinationRef);
                    continue;
                }
                if (!"transaction".equals(resourceType)) continue;
                ContextTransaction contextTransaction = new ContextTransaction();
                BeanInspectUtils.transmitProperties((Object)contextTransaction, jndiResource);
                BeanInspectUtils.transmitProperty(contextTransaction, "pathname", pathnameValue);
                namingResources.setTransaction(contextTransaction);
            }
        }
        if (null != (resources = this.context.getConfigBean().getElement("resources")) && null != (jdbcResources = resources.getElements("jdbc-resource"))) {
            for (DomTemplate jdbcResource : jdbcResources) {
                String connectionInitSqls;
                String usingTrace;
                String logFailed;
                String logSlow;
                String maxQueries;
                String enableSharingResources;
                String fairness;
                String sqlTrace;
                String defaultCatalog;
                String poolStatements;
                String rollbackOnReturn;
                String enableAutoCommitOnReturn;
                String logAbandoned;
                String enableLeakageRecovery;
                String validateAtmostOncePeriodInSeconds;
                String accessToUnderlyingConnectionAllowd;
                String isolationLevel;
                String maxConnectionAge;
                String fetchSize;
                String statementTimeoutInSeconds;
                String validationQueryTimeout;
                String statementCacheSize;
                int finalValue;
                String timeBetweenEvictionRunsMillis;
                String connectionLeakTimeoutInSeconds;
                String maxEvictableIdleTimeout;
                String failAllConnection;
                String testWhileIdle;
                String testOnBorrow;
                String validationQuery;
                String maxWaitTimeInMillis;
                String maxPoolSize;
                String minIdle;
                String initialPoolSize;
                String password;
                String username;
                String url;
                String jndiName = jdbcResource.getAttribute("name");
                contextResource = new ContextResource();
                contextResource.setName(jndiName);
                contextResource.setType(jdbcResource.getAttribute("resource-type"));
                contextResource.setScope("Shareable");
                contextResource.setAuth("Container");
                contextResource.setSingleton(true);
                contextResource.setProperty("scope", "Shareable");
                contextResource.setProperty("auth", "Container");
                contextResource.setProperty("name", jndiName);
                contextResource.setProperty("jmxName", "com.bes.enterprise.management:type=datasources,name=" + jndiName);
                String driverClassName = jdbcResource.getAttribute("driver-class-name");
                if (!StringUtils.isBlank((String)driverClassName)) {
                    contextResource.setProperty("driverClassName", driverClassName);
                }
                if (!StringUtils.isBlank((String)(url = jdbcResource.getAttribute("url")))) {
                    contextResource.setProperty("url", url);
                }
                if (!StringUtils.isBlank((String)(username = jdbcResource.getAttribute("username")))) {
                    contextResource.setProperty("username", username);
                }
                if (!StringUtils.isBlank((String)(password = jdbcResource.getAttribute("password")))) {
                    contextResource.setProperty("password", password);
                }
                if (!StringUtils.isBlank((String)(initialPoolSize = jdbcResource.getAttribute("initial-pool-size")))) {
                    contextResource.setProperty("initialPoolSize", initialPoolSize);
                }
                if (!StringUtils.isBlank((String)(minIdle = jdbcResource.getAttribute("min-idle")))) {
                    contextResource.setProperty("minIdle", minIdle);
                }
                if (!StringUtils.isBlank((String)(maxPoolSize = jdbcResource.getAttribute("max-pool-size")))) {
                    contextResource.setProperty("maxPoolSize", maxPoolSize);
                }
                if (!StringUtils.isBlank((String)(maxWaitTimeInMillis = jdbcResource.getAttribute("max-wait-time-in-millis")))) {
                    contextResource.setProperty("maxWaitTimeInMillis", maxWaitTimeInMillis);
                }
                if (!StringUtils.isBlank((String)(validationQuery = jdbcResource.getAttribute("validation-query")))) {
                    contextResource.setProperty("validationQuery", validationQuery);
                }
                if (!StringUtils.isBlank((String)(testOnBorrow = jdbcResource.getAttribute("test-on-borrow")))) {
                    contextResource.setProperty("testOnBorrow", testOnBorrow);
                }
                if (StringUtils.ok((String)(testWhileIdle = jdbcResource.getAttribute("test-while-idle")))) {
                    contextResource.setProperty("testWhileIdle", testWhileIdle);
                }
                if (StringUtils.ok((String)(failAllConnection = jdbcResource.getAttribute("fail-all-connection")))) {
                    contextResource.setProperty("failAllConnection", failAllConnection);
                }
                String idleTimeout = jdbcResource.getAttribute("idle-timeout");
                int idleTimeoutIntValue = 300;
                if (StringUtils.ok((String)idleTimeout)) {
                    idleTimeoutIntValue = Integer.parseInt(idleTimeout);
                    contextResource.setProperty("idleTimeout", idleTimeout);
                }
                if (StringUtils.ok((String)(maxEvictableIdleTimeout = jdbcResource.getAttribute("max-evictable-idle-timeout")))) {
                    contextResource.setProperty("maxEvictableIdleTimeout", maxEvictableIdleTimeout);
                }
                if (StringUtils.ok((String)(connectionLeakTimeoutInSeconds = jdbcResource.getAttribute("connection-leak-timeout-in-seconds")))) {
                    contextResource.setProperty("connectionLeakTimeoutInSeconds", connectionLeakTimeoutInSeconds);
                }
                if (StringUtils.ok((String)(timeBetweenEvictionRunsMillis = jdbcResource.getAttribute("time-between-eviction-runs-millis")))) {
                    contextResource.setProperty("timeBetweenEvictionRunsMillis", timeBetweenEvictionRunsMillis);
                } else {
                    int dataToCalculate;
                    int finalConnectionLeakTimeout = 0;
                    if (StringUtils.ok((String)connectionLeakTimeoutInSeconds)) {
                        finalConnectionLeakTimeout = Integer.parseInt(connectionLeakTimeoutInSeconds);
                    }
                    int n2 = dataToCalculate = idleTimeoutIntValue > 0 && finalConnectionLeakTimeout > 0 ? Math.min(idleTimeoutIntValue, finalConnectionLeakTimeout) : Math.max(idleTimeoutIntValue, finalConnectionLeakTimeout);
                    if (dataToCalculate > 0) {
                        finalValue = Math.min(dataToCalculate * 1000 / 3, Integer.valueOf(timeBetweenEvictionRunsMillisUpper));
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.info(String.format("The calculated value of betweenEvictionRunsMillis for resource %s is %d!", jndiName, finalValue));
                        }
                        contextResource.setProperty("timeBetweenEvictionRunsMillis", String.valueOf(finalValue));
                    } else {
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.info(String.format("The calculated value of betweenEvictionRunsMillis for resource %s not greater than 0,use %s instead!", jndiName, timeBetweenEvictionRunsMillisUpper));
                        }
                        contextResource.setProperty("timeBetweenEvictionRunsMillis", timeBetweenEvictionRunsMillisUpper);
                    }
                }
                String numTestsPerEvictionRun = jdbcResource.getAttribute("num-tests-per-eviction-run");
                if (StringUtils.ok((String)numTestsPerEvictionRun)) {
                    int numTestsPerEvictionRunValue = Integer.valueOf(numTestsPerEvictionRun);
                    if (numTestsPerEvictionRunValue >= 0) {
                        contextResource.setProperty("numTestsPerEvictionRun", numTestsPerEvictionRun);
                    } else {
                        finalValue = (int)Math.ceil(Integer.valueOf(maxPoolSize) / Math.abs(numTestsPerEvictionRunValue));
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.info(String.format("The value for property numTestsPerEvictionRun of resource %s is %s, less than 0, use %d instead!", jndiName, numTestsPerEvictionRun, finalValue));
                        }
                        contextResource.setProperty("numTestsPerEvictionRun", String.valueOf(finalValue));
                    }
                } else {
                    if (_logger.isLoggable(Level.INFO)) {
                        _logger.info(String.format("No specified value for property numTestsPerEvictionRun of resource %s, use max-pool-size (%s) instead!", jndiName, maxPoolSize));
                    }
                    contextResource.setProperty("numTestsPerEvictionRun", maxPoolSize);
                }
                String poolPreparedStatements = jdbcResource.getAttribute("pool-prepared-statements");
                if (!StringUtils.isBlank((String)poolPreparedStatements)) {
                    contextResource.setProperty("poolPreparedStatements", poolPreparedStatements);
                }
                if (!StringUtils.isBlank((String)(statementCacheSize = jdbcResource.getAttribute("statement-cache-size")))) {
                    contextResource.setProperty("statementCacheSize", statementCacheSize);
                }
                if (!StringUtils.isBlank((String)(validationQueryTimeout = jdbcResource.getAttribute("validation-query-timeout")))) {
                    contextResource.setProperty("validationQueryTimeout", validationQueryTimeout);
                }
                if (StringUtils.ok((String)(statementTimeoutInSeconds = jdbcResource.getAttribute("statement-timeout-in-seconds")))) {
                    contextResource.setProperty("statementTimeoutInSeconds", statementTimeoutInSeconds);
                }
                if (!StringUtils.isBlank((String)(fetchSize = jdbcResource.getAttribute("fetch-size")))) {
                    contextResource.setProperty("fetchSize", fetchSize);
                }
                if (StringUtils.ok((String)(maxConnectionAge = jdbcResource.getAttribute("max-connection-age")))) {
                    contextResource.setProperty("maxConnectionAge", maxConnectionAge);
                }
                if (StringUtils.ok((String)(isolationLevel = jdbcResource.getAttribute("isolation-level")))) {
                    contextResource.setProperty("isolationLevel", isolationLevel);
                }
                if (StringUtils.ok((String)(accessToUnderlyingConnectionAllowd = jdbcResource.getAttribute("access-to-underlying-connection-allowed")))) {
                    contextResource.setProperty("accessToUnderlyingConnectionAllowed", accessToUnderlyingConnectionAllowd);
                }
                if (StringUtils.ok((String)(validateAtmostOncePeriodInSeconds = jdbcResource.getAttribute("validate-atmost-once-period-in-seconds")))) {
                    contextResource.setProperty("validateAtmostOncePeriodInSeconds", validateAtmostOncePeriodInSeconds);
                }
                if (StringUtils.ok((String)(enableLeakageRecovery = jdbcResource.getAttribute("enable-leakage-recovery")))) {
                    contextResource.setProperty("enableLeakageRecovery", enableLeakageRecovery);
                }
                if (StringUtils.ok((String)(logAbandoned = jdbcResource.getAttribute("log-abandoned")))) {
                    contextResource.setProperty("logAbandoned", logAbandoned);
                }
                if (StringUtils.ok((String)(enableAutoCommitOnReturn = jdbcResource.getAttribute("enable-auto-commit-on-return")))) {
                    contextResource.setProperty("enableAutoCommitOnReturn", enableAutoCommitOnReturn);
                }
                if (StringUtils.ok((String)(rollbackOnReturn = jdbcResource.getAttribute("rollback-on-return")))) {
                    contextResource.setProperty("rollbackOnReturn", rollbackOnReturn);
                }
                if (StringUtils.ok((String)(poolStatements = jdbcResource.getAttribute("pool-statements")))) {
                    contextResource.setProperty("poolStatements", poolStatements);
                }
                if (StringUtils.ok((String)(defaultCatalog = jdbcResource.getAttribute("default-catalog")))) {
                    contextResource.setProperty("defaultCatalog", defaultCatalog);
                }
                if (StringUtils.ok((String)(sqlTrace = jdbcResource.getAttribute("sql-trace")))) {
                    contextResource.setProperty("sqlTrace", sqlTrace);
                }
                if (StringUtils.ok((String)(fairness = jdbcResource.getAttribute("fairness")))) {
                    contextResource.setProperty("fairness", fairness);
                }
                if (StringUtils.ok((String)(enableSharingResources = jdbcResource.getAttribute("enable-sharing-resources")))) {
                    contextResource.setProperty("enableSharingResources", enableSharingResources);
                }
                if (StringUtils.ok((String)(maxQueries = jdbcResource.getAttribute("max-queries")))) {
                    contextResource.setProperty("maxQueries", maxQueries);
                }
                if (StringUtils.ok((String)(logSlow = jdbcResource.getAttribute("log-slow")))) {
                    contextResource.setProperty("logSlow", logSlow);
                }
                if (StringUtils.ok((String)(logFailed = jdbcResource.getAttribute("log-failed")))) {
                    contextResource.setProperty("logFailed", logFailed);
                }
                if (StringUtils.ok((String)(usingTrace = jdbcResource.getAttribute("using-trace")))) {
                    contextResource.setProperty("usingTrace", usingTrace);
                }
                if (StringUtils.ok((String)(connectionInitSqls = jdbcResource.getAttribute("connection-init-sqls")))) {
                    contextResource.setProperty("connectionInitSqls", connectionInitSqls);
                }
                List<DomTemplate> properties = jdbcResource.getElements("property");
                for (DomTemplate property : properties) {
                    String propName = property.getAttribute("name");
                    String propValue = property.getAttribute("value");
                    contextResource.setProperty(propName, propValue);
                }
                namingResources.addResource(contextResource);
            }
        }
        this._embedded.getServer().setGlobalNamingResources(namingResources);
    }

    public ServerContext getContext() {
        return this.context;
    }

    protected Object loadInstance(String className) {
        try {
            return this.context.getCommonClassLoader().loadClass(className).newInstance();
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Faild to create instance for " + className, ex);
            }
            return null;
        }
    }

    static {
        translator = SystemPropertyValueTranslator.getInstance();
        outAndErrNotRedirect = Boolean.getBoolean("com.bes.enterprise.log.outAndErrNotRedirect");
        omitOutAndErr = Boolean.getBoolean("com.bes.enterprise.log.omitOutAndErr");
    }
}

