/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web;

import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.context.ServerContext;
import com.bes.enterprise.web.BESWebContainer;
import com.bes.enterprise.web.CloudWebContainer;
import com.bes.enterprise.web.VirtualHost;
import com.bes.enterprise.webtier.Engine;
import com.bes.enterprise.webtier.core.ApplicationServer;
import com.bes.enterprise.webtier.core.DefaultEngine;
import com.bes.enterprise.webtier.valves.AccessLogValve;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;

public class EmbeddedCloudWebContainer
extends CloudWebContainer {
    protected EmbeddedCloudWebContainer(String id, ServerContext context) {
        super(id, context);
    }

    public static BESWebContainer createInstance(ServerContext context) {
        webContainer = new EmbeddedCloudWebContainer("0", context);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Creating new instance of EmbeddedCloudWebContainer.");
        }
        ((EmbeddedCloudWebContainer)webContainer).init(context);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Initialization of EmbeddedCloudWebContainer.");
        }
        return webContainer;
    }

    @Override
    protected void initStdLog() {
    }

    @Override
    protected void init(ServerContext context) {
        this.connectorMap = new HashMap();
        try {
            DomTemplate serverBean = context.getConfigBean();
            DomTemplate wcBean = serverBean.getElement("web-container");
            ApplicationServer server = this.createServer(serverBean);
            this._embedded.setServer(server);
            server.addService(this._embedded);
            this.loadRealms(serverBean.getElement("security-service"));
            Engine engine = this.createEngine(serverBean);
            this.createConnectors(wcBean);
            this.configEngine(engine, wcBean);
            this.createResources();
            boolean globalAccessLogEnabled = Boolean.valueOf(wcBean.getElement("http-service").getAttribute("global-access-log-enabled"));
            this.createHosts(wcBean, globalAccessLogEnabled, serverBean);
            this.cleanWorkDir(wcBean, engine.getName());
        }
        catch (Exception e2) {
            _logger.log(Level.SEVERE, "webcontainer.configError", e2);
            throw new RuntimeException(e2);
        }
    }

    @Override
    protected ApplicationServer createServer(DomTemplate serverBean) {
        ApplicationServer server = new ApplicationServer();
        server.setAddress(serverBean.getAttribute("adminhost"));
        server.setPort(Integer.parseInt(serverBean.getAttribute("adminport")));
        server.setShutdown(serverBean.getAttribute("stop"));
        return server;
    }

    @Override
    protected Engine createEngine(DomTemplate serverBean) {
        String engineName = "com.bes.appserv";
        Engine engine = this._embedded.createEngine(null);
        this._embedded.setContainer(engine);
        engine.setService(this._embedded);
        engine.setParentClassLoader(this.context.getSharedClassLoader());
        ((DefaultEngine)engine).setName(engineName);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Creating Engine " + engineName);
        }
        return engine;
    }

    protected void createHosts(DomTemplate httpService, boolean globalAccessLoggingEnabled, DomTemplate serverBean) {
        DomTemplate[] vses = httpService.getElements("virtual-server").toArray(new DomTemplate[0]);
        for (int j2 = 0; j2 < vses.length; ++j2) {
            this.createHost(httpService, vses[j2], globalAccessLoggingEnabled, serverBean);
        }
    }

    protected VirtualHost createHost(DomTemplate webcontainer, DomTemplate vse, boolean globalAccessLoggingEnabled, DomTemplate serverBean) {
        Engine engine = this._embedded.getContainer();
        String docroot = translator.getTranslatedValue(vse.getAttribute("app-base"));
        if (!new File(docroot).isAbsolute()) {
            docroot = new File(System.getProperty("com.bes.instanceRoot"), docroot).getAbsolutePath();
        }
        String vs_id = vse.getAttribute("name");
        VirtualHost vs = this.createVS(vs_id, vse, docroot, null);
        boolean accessLoggingEnabled = this.isAccessLoggingEnabled(vse, globalAccessLoggingEnabled);
        if (accessLoggingEnabled) {
            AccessLogValve accessLogValve = this.loadHostAccessLog(webcontainer.getElement("http-service").getElement("access-log"), vse);
            accessLogValve.setEnabled(true);
            vs.addValve(accessLogValve);
        }
        this.configureHost(vs, vse);
        engine.addChild(vs);
        vs.setParent(engine);
        vs.setParentClassLoader(this.context.getSharedClassLoader());
        return vs;
    }

    protected void configureHost(VirtualHost vs, DomTemplate vsBean) {
        vs.configureAliases();
        vs.setAutoDeploy(Boolean.parseBoolean(vsBean.getAttribute("auto-deploy")));
    }
}

