/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web;

import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.miniparser.SystemPropertyValueTranslator;
import com.bes.enterprise.context.ServerContext;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.BESCoyoteConnector;
import com.bes.enterprise.web.BESWebContainer;
import com.bes.enterprise.web.VirtualHost;
import com.bes.enterprise.webtier.Engine;
import com.bes.enterprise.webtier.Host;
import com.bes.enterprise.webtier.Lifecycle;
import com.bes.enterprise.webtier.Realm;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.core.DefaultEngine;
import com.bes.enterprise.webtier.core.DefaultService;
import com.bes.enterprise.webtier.valves.StuckThreadDetectionValve;

public final class EmbeddedWebContainer
extends DefaultService
implements Lifecycle {
    protected Log log = LogFactory.getLog(EmbeddedWebContainer.class.getName());
    private static SystemPropertyValueTranslator translator = SystemPropertyValueTranslator.getInstance();
    private BESWebContainer webContainer;

    public EmbeddedWebContainer(ServerContext context, BESWebContainer webContainer) {
        this.webContainer = webContainer;
    }

    public Connector[] getConnectors() {
        return this.connectors;
    }

    public Connector createConnector(String address, int port, String protocol) {
        int index;
        if (address != null && (index = address.indexOf(47)) != -1) {
            address = address.substring(index + 1);
        }
        this.log.debug("Creating connector for address='" + (address == null ? "ALL" : address) + "' port='" + port + "' protocol='" + protocol + "'");
        BESCoyoteConnector connector = new BESCoyoteConnector(protocol);
        if (address != null) {
            connector.setProperty("address", address);
        }
        connector.setPort(port);
        return connector;
    }

    public Host createHost(String vsID, DomTemplate vsBean, String vsDocroot) {
        VirtualHost vs = new VirtualHost();
        vs.setAppBase(vsDocroot);
        vs.setName(vsID);
        vs.setXmlBase(translator.getTranslatedValue(vsBean.getAttribute("xml-base")));
        if (vsBean.getAttribute("create-dirs") != null) {
            vs.setCreateDirs(Boolean.parseBoolean(vsBean.getAttribute("create-dirs")));
        }
        if (vsBean.getAttribute("auto-deploy") != null) {
            vs.setAutoDeploy(Boolean.parseBoolean(vsBean.getAttribute("auto-deploy")));
        }
        if (vsBean.getAttribute("background-processor-delay") != null) {
            vs.setBackgroundProcessorDelay(Integer.parseInt(vsBean.getAttribute("background-processor-delay")));
        }
        if (vsBean.getAttribute("deploy-ignore") != null) {
            vs.setDeployIgnore(vsBean.getAttribute("deploy-ignore"));
        }
        if (vsBean.getAttribute("deploy-on-startup") != null) {
            vs.setDeployOnStartup(Boolean.parseBoolean(vsBean.getAttribute("deploy-on-startup")));
        }
        if (vsBean.getAttribute("fail-ctx-if-servlet-start-fails") != null) {
            vs.setFailCtxIfServletStartFails(Boolean.parseBoolean(vsBean.getAttribute("fail-ctx-if-servlet-start-fails")));
        }
        if (vsBean.getAttribute("start-stop-threads") != null) {
            vs.setStartStopThreads(Integer.parseInt(vsBean.getAttribute("start-stop-threads")));
        }
        if (vsBean.getAttribute("undeploy-old-versions") != null) {
            vs.setUndeployOldVersions(Boolean.parseBoolean(vsBean.getAttribute("undeploy-old-versions")));
        }
        if (vsBean.getAttribute("copy-xml") != null) {
            vs.setCopyXML(Boolean.parseBoolean(vsBean.getAttribute("copy-xml")));
        }
        if (vsBean.getAttribute("deploy-xml") != null) {
            vs.setDeployXML(Boolean.parseBoolean(vsBean.getAttribute("deploy-xml")));
        }
        if (vsBean.getAttribute("error-report-valve-class") != null) {
            vs.setErrorReportValveClass(vsBean.getAttribute("error-report-valve-class"));
        }
        if (vsBean.getAttribute("unpack-wars") != null) {
            vs.setUnpackWARs(Boolean.parseBoolean(vsBean.getAttribute("unpack-wars")));
        }
        if (vsBean.getAttribute("stuck-thread-max-time") != null && Integer.parseInt(vsBean.getAttribute("stuck-thread-max-time")) != 0) {
            StuckThreadDetectionValve valve = new StuckThreadDetectionValve();
            valve.setThreshold(Integer.parseInt(vsBean.getAttribute("stuck-thread-max-time")));
            vs.addValve(valve);
            String stuckThreadTimerInterval = vsBean.getAttribute("stuck-thread-timer-interval");
            if (stuckThreadTimerInterval != null && Integer.parseInt(stuckThreadTimerInterval) != vs.getBackgroundProcessorDelay()) {
                vs.setBackgroundProcessorDelay(Integer.parseInt(stuckThreadTimerInterval));
            }
        }
        vs.setWorkDir(translator.getTranslatedValue(vsBean.getAttribute("work-dir")));
        vs.setBean(vsBean);
        return vs;
    }

    public Engine createEngine(Realm realm) {
        WebEngine engine = new WebEngine(this.webContainer, this.log);
        engine.setRealm(realm);
        return engine;
    }

    static class WebEngine
    extends DefaultEngine {
        private BESWebContainer webContainer;
        private Log _logger;

        public WebEngine(BESWebContainer webContainer, Log _logger) {
            this.webContainer = webContainer;
            this._logger = _logger;
        }
    }
}

