/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web;

import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.miniparser.SystemPropertyValueTranslator;
import com.bes.enterprise.context.ServerContext;
import com.bes.enterprise.web.BESWebContainer;
import com.bes.enterprise.web.BesVirtualHostValve;
import com.bes.enterprise.web.util.BeanInspectUtils;
import com.bes.enterprise.webtier.Valve;
import com.bes.enterprise.webtier.authenticator.SingleSignOn;
import com.bes.enterprise.webtier.core.DefaultHost;
import com.bes.enterprise.webtier.valves.ErrorReportValve;
import com.bes.enterprise.webtier.valves.RemoteAddrValve;
import com.bes.enterprise.webtier.valves.RemoteHostValve;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VirtualHost
extends DefaultHost {
    static final String STATE = "state";
    static final String SSO_MAX_IDLE = "sso-max-inactive-seconds";
    static final String SSO_REAP_INTERVAL = "sso-reap-interval-seconds";
    static final String DISABLED = "disabled";
    static final String OFF = "off";
    static final String ON = "on";
    protected static final Logger _logger = Logger.getLogger(BESWebContainer.class.getName());
    DomTemplate vsBean;

    public DomTemplate getBean() {
        return this.vsBean;
    }

    public void setBean(DomTemplate vsBean) {
        this.vsBean = vsBean;
    }

    public void configureAliases() {
        String hosts = this.vsBean.getAttribute("hosts");
        if (hosts != null) {
            for (String alias : hosts.split(",")) {
                this.addAlias(alias);
            }
        }
    }

    public void configureErrorReportValve(ServerContext context) {
        if (this.vsBean.getAttribute("error-report-valve-class") != null) {
            this.setErrorReportValveClass(this.vsBean.getAttribute("error-report-valve-class"));
        } else {
            this.setErrorReportValveClass(ErrorReportValve.class.getName());
        }
        ErrorReportValve erValue = (ErrorReportValve)this.loadValve(context, this.getErrorReportValveClass());
        erValue.setShowServerInfo(Boolean.getBoolean("com.bes.enterprise.web.showServerInfo"));
        this.addValve(erValue);
    }

    public void configureRemoteAddressFilterValve() {
        RemoteAddrValve remoteAddrValve = null;
        String allowValue = this.getVsBeanPropertyByName("allowRemoteAddress", this.vsBean);
        String denyValue = this.getVsBeanPropertyByName("denyRemoteAddress", this.vsBean);
        if (allowValue != null || denyValue != null) {
            remoteAddrValve = new RemoteAddrValve();
        }
        if (allowValue != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.fine("Allowing access to " + this.vsBean.getAttribute("name") + " from " + allowValue);
            }
            remoteAddrValve.setAllow(allowValue);
        }
        if (denyValue != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.fine("Denying access to " + this.vsBean.getAttribute("name") + " from " + denyValue);
            }
            remoteAddrValve.setDeny(denyValue);
        }
        if (remoteAddrValve != null) {
            this.addValve(remoteAddrValve);
        }
    }

    public void configureRemoteHostFilterValve() {
        RemoteHostValve remoteHostValve = null;
        if (this.vsBean == null) {
            return;
        }
        String allowValue = this.getVsBeanPropertyByName("allowRemoteHost", this.vsBean);
        String denyValue = this.getVsBeanPropertyByName("denyRemoteHost", this.vsBean);
        if (allowValue != null || denyValue != null) {
            remoteHostValve = new RemoteHostValve();
        }
        if (allowValue != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.fine("Allowing access to " + this.vsBean.getAttribute("name") + " from " + allowValue);
            }
            remoteHostValve.setAllow(allowValue);
        }
        if (denyValue != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.fine("Denying access to " + this.vsBean.getAttribute("name") + " from " + denyValue);
            }
            remoteHostValve.setDeny(denyValue);
        }
        if (remoteHostValve != null) {
            this.addValve(remoteHostValve);
        }
    }

    public void configureVirtualServerState() {
        if (!this.vsBean.getAttribute(STATE).equalsIgnoreCase(ON)) {
            BesVirtualHostValve vsValve = new BesVirtualHostValve(this);
            if (this.vsBean.getAttribute(STATE).equalsIgnoreCase(OFF)) {
                vsValve.setOff(true);
            } else if (this.vsBean.getAttribute(STATE).equalsIgnoreCase(DISABLED)) {
                vsValve.setDisabled(true);
            }
            this.addValve(vsValve);
        }
    }

    public void configureSSOValve() {
        if (this.vsBean.getElement("single-sign-on") != null) {
            SingleSignOn valve = new SingleSignOn();
            BeanInspectUtils.transmitProperties((Object)valve, this.vsBean.getElement("single-sign-on"));
            this.addValve(valve);
        }
    }

    public void configureOtherValves(ServerContext context) {
        for (DomTemplate valve : this.vsBean.getElements("valve")) {
            Valve besValve = this.loadValve(context, valve.getAttribute("class-name"));
            if (besValve == null) continue;
            BeanInspectUtils.transmitProperties((Object)besValve, valve);
            BeanInspectUtils.transmitProperties((Object)besValve, this.vsBean.getElements("property"));
            this.addValve(besValve);
        }
    }

    protected Valve loadValve(ServerContext context, String className) {
        try {
            return (Valve)context.getCommonClassLoader().loadClass(className).newInstance();
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Faild to create valve for " + className, ex);
            }
            return null;
        }
    }

    protected String getVsBeanPropertyByName(String name, DomTemplate vsBean) {
        String value = null;
        for (DomTemplate property : vsBean.getElements("property")) {
            if (!property.getAttribute("name").equals(name)) continue;
            value = SystemPropertyValueTranslator.getInstance().getTranslatedValue(property.getAttribute("value"));
            break;
        }
        return value;
    }
}

