/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.crane;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.web.InstanceManager;
import com.bes.enterprise.web.crane.AbstractProcessor;
import com.bes.enterprise.web.crane.Adapter;
import com.bes.enterprise.web.crane.ContainerThreadMarker;
import com.bes.enterprise.web.crane.Processor;
import com.bes.enterprise.web.crane.ProtocolException;
import com.bes.enterprise.web.crane.ProtocolHandler;
import com.bes.enterprise.web.crane.Request;
import com.bes.enterprise.web.crane.RequestGroupInfo;
import com.bes.enterprise.web.crane.RequestInfo;
import com.bes.enterprise.web.crane.UpgradeProtocol;
import com.bes.enterprise.web.crane.UpgradeToken;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.collections.SynchronizedStack;
import com.bes.enterprise.web.util.modeler.Registry;
import com.bes.enterprise.web.util.net.AbstractEndpoint;
import com.bes.enterprise.web.util.net.SocketEvent;
import com.bes.enterprise.web.util.net.SocketWrapperBase;
import com.bes.enterprise.web.util.res.StringManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;

public abstract class AbstractProtocol<S>
implements ProtocolHandler,
MBeanRegistration {
    private static final StringManager sm = StringManager.getManager(AbstractProtocol.class);
    private static final AtomicInteger nameCounter = new AtomicInteger(0);
    protected ObjectName rgOname = null;
    private int nameIndex = 0;
    private final AbstractEndpoint<S> endpoint;
    private AbstractEndpoint.Handler<S> handler;
    private final Set<Processor> waitingProcessors = Collections.newSetFromMap(new ConcurrentHashMap());
    private AsyncTimeout asyncTimeout = null;
    protected Adapter adapter;
    protected int processorCache = 200;
    protected String clientCertProvider = null;
    @Deprecated
    private boolean sendReasonPhrase = false;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public AbstractProtocol(AbstractEndpoint<S> endpoint) {
        this.endpoint = endpoint;
        this.setConnectionLinger(-1);
        this.setTcpNoDelay(true);
    }

    public boolean setProperty(String name, String value) {
        return this.endpoint.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.endpoint.getProperty(name);
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String s2) {
        this.clientCertProvider = s2;
    }

    @Override
    public boolean isNativeRequired() {
        return false;
    }

    @Override
    public boolean isSendfileSupported() {
        return this.endpoint.getUseSendfile();
    }

    public AsyncTimeout getAsyncTimeout() {
        return this.asyncTimeout;
    }

    @Deprecated
    public boolean getSendReasonPhrase() {
        return this.sendReasonPhrase;
    }

    @Deprecated
    public void setSendReasonPhrase(boolean sendReasonPhrase) {
        this.sendReasonPhrase = sendReasonPhrase;
    }

    @Override
    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.endpoint.setMaxThreads(maxThreads);
    }

    public int getMaxConnections() {
        return this.endpoint.getMaxConnections();
    }

    public void setMaxConnections(int maxConnections) {
        this.endpoint.setMaxConnections(maxConnections);
    }

    public int getMinSpareThreads() {
        return this.endpoint.getMinSpareThreads();
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.endpoint.setMinSpareThreads(minSpareThreads);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.endpoint.setThreadPriority(threadPriority);
    }

    public int getAcceptCount() {
        return this.endpoint.getAcceptCount();
    }

    public void setAcceptCount(int acceptCount) {
        this.endpoint.setAcceptCount(acceptCount);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.endpoint.setTcpNoDelay(tcpNoDelay);
    }

    public int getConnectionLinger() {
        return this.endpoint.getConnectionLinger();
    }

    public void setConnectionLinger(int connectionLinger) {
        this.endpoint.setConnectionLinger(connectionLinger);
    }

    public int getKeepAliveTimeout() {
        return this.endpoint.getKeepAliveTimeout();
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.endpoint.setKeepAliveTimeout(keepAliveTimeout);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.endpoint.setAddress(ia);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int port) {
        this.endpoint.setPort(port);
    }

    public int getLocalPort() {
        return this.endpoint.getLocalPort();
    }

    public int getConnectionTimeout() {
        return this.endpoint.getConnectionTimeout();
    }

    public void setConnectionTimeout(int timeout) {
        this.endpoint.setConnectionTimeout(timeout);
    }

    @Deprecated
    public int getSoTimeout() {
        return this.getConnectionTimeout();
    }

    @Deprecated
    public void setSoTimeout(int timeout) {
        this.setConnectionTimeout(timeout);
    }

    public int getMaxHeaderCount() {
        return this.endpoint.getMaxHeaderCount();
    }

    public void setMaxHeaderCount(int maxHeaderCount) {
        this.endpoint.setMaxHeaderCount(maxHeaderCount);
    }

    public long getConnectionCount() {
        return this.endpoint.getConnectionCount();
    }

    public void setAcceptorThreadCount(int threadCount) {
        this.endpoint.setAcceptorThreadCount(threadCount);
    }

    public int getAcceptorThreadCount() {
        return this.endpoint.getAcceptorThreadCount();
    }

    public void setAcceptorThreadPriority(int threadPriority) {
        this.endpoint.setAcceptorThreadPriority(threadPriority);
    }

    public int getAcceptorThreadPriority() {
        return this.endpoint.getAcceptorThreadPriority();
    }

    public synchronized int getNameIndex() {
        if (this.nameIndex == 0) {
            this.nameIndex = nameCounter.incrementAndGet();
        }
        return this.nameIndex;
    }

    public String getName() {
        return ObjectName.quote(this.getNameInternal());
    }

    private String getNameInternal() {
        int port;
        StringBuilder name = new StringBuilder(this.getNamePrefix());
        name.append('-');
        if (this.getAddress() != null) {
            name.append(this.getAddress().getHostAddress());
            name.append('-');
        }
        if ((port = this.getPort()) == 0) {
            name.append("auto-");
            name.append(this.getNameIndex());
            port = this.getLocalPort();
            if (port != -1) {
                name.append('-');
                name.append(port);
            }
        } else {
            name.append(port);
        }
        return name.toString();
    }

    public void addWaitingProcessor(Processor processor) {
        this.waitingProcessors.add(processor);
    }

    public void removeWaitingProcessor(Processor processor) {
        this.waitingProcessors.remove(processor);
    }

    protected AbstractEndpoint<S> getEndpoint() {
        return this.endpoint;
    }

    protected AbstractEndpoint.Handler<S> getHandler() {
        return this.handler;
    }

    protected void setHandler(AbstractEndpoint.Handler<S> handler) {
        this.handler = handler;
    }

    protected abstract Log getLog();

    protected abstract String getNamePrefix();

    protected abstract String getProtocolName();

    protected abstract UpgradeProtocol getNegotiatedProtocol(String var1);

    protected abstract UpgradeProtocol getUpgradeProtocol(String var1);

    protected abstract Processor createProcessor();

    protected abstract Processor createUpgradeProcessor(SocketWrapperBase<?> var1, UpgradeToken var2);

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    private ObjectName createObjectName(String cName) throws MalformedObjectNameException {
        this.domain = this.getAdapter().getDomain();
        if (this.domain == null) {
            return null;
        }
        StringBuilder name = new StringBuilder(this.getDomain());
        name.append(":type=ProtocolHandler,name=");
        name.append(cName);
        return new ObjectName(name.toString());
    }

    @Override
    public void init(String name) throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.init", this.getName()));
        }
        if (this.oname == null) {
            this.oname = this.createObjectName(name);
            if (this.oname != null) {
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
        }
        if (this.domain != null) {
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + name);
            Registry.getRegistry(null, null).registerComponent(this.getHandler().getGlobal(), this.rgOname, null);
        }
        String endpointName = this.getName();
        this.endpoint.setName(endpointName.substring(1, endpointName.length() - 1));
        this.endpoint.setDomain(this.domain);
        this.endpoint.init();
    }

    @Override
    public void start() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.start", this.getName()));
        }
        this.endpoint.start();
        this.asyncTimeout = new AsyncTimeout();
        Thread timeoutThread = new Thread((Runnable)this.asyncTimeout, "AsyncTimeoutThread-" + this.getPort());
        int priority = this.endpoint.getThreadPriority();
        if (priority < 1 || priority > 10) {
            priority = 5;
        }
        timeoutThread.setPriority(priority);
        timeoutThread.setDaemon(true);
        timeoutThread.start();
    }

    @Override
    public void pause() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.pause", this.getName()));
        }
        this.endpoint.pause();
    }

    @Override
    public void resume() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.resume", this.getName()));
        }
        this.endpoint.resume();
    }

    @Override
    public void stop() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.stop", this.getName()));
        }
        if (this.asyncTimeout != null) {
            this.asyncTimeout.stop();
        }
        this.endpoint.stop();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws Exception {
        block10: {
            block11: {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info(sm.getString("abstractProtocolHandler.destroy", this.getName()));
                }
                try {
                    this.endpoint.destroy();
                    if (this.oname == null) break block10;
                    if (this.mserver != null) break block11;
                    Registry.getRegistry(null, null).unregisterComponent(this.oname);
                    break block10;
                }
                catch (Throwable throwable) {
                    if (this.oname != null) {
                        if (this.mserver == null) {
                            Registry.getRegistry(null, null).unregisterComponent(this.oname);
                        } else {
                            try {
                                this.mserver.unregisterMBean(this.oname);
                            }
                            catch (InstanceNotFoundException | MBeanRegistrationException e2) {
                                this.getLog().info(sm.getString("abstractProtocol.mbeanDeregistrationFailed", this.oname, this.mserver));
                            }
                        }
                    }
                    if (this.rgOname == null) throw throwable;
                    Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
                    throw throwable;
                }
            }
            try {
                this.mserver.unregisterMBean(this.oname);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException e3) {
                this.getLog().info(sm.getString("abstractProtocol.mbeanDeregistrationFailed", this.oname, this.mserver));
            }
        }
        if (this.rgOname == null) return;
        Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
    }

    @Override
    public void closeServerSocketGraceful() {
        this.endpoint.closeServerSocketGraceful();
    }

    protected class AsyncTimeout
    implements Runnable {
        private volatile boolean asyncTimeoutRunning = true;

        protected AsyncTimeout() {
        }

        @Override
        public void run() {
            while (this.asyncTimeoutRunning) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long now = System.currentTimeMillis();
                for (Processor processor : AbstractProtocol.this.waitingProcessors) {
                    processor.timeoutAsync(now);
                }
                while (AbstractProtocol.this.endpoint.isPaused() && this.asyncTimeoutRunning) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        protected void stop() {
            this.asyncTimeoutRunning = false;
            for (Processor processor : AbstractProtocol.this.waitingProcessors) {
                processor.timeoutAsync(-1L);
            }
        }
    }

    protected static class RecycledProcessors
    extends SynchronizedStack<Processor> {
        private final transient ConnectionHandler<?> handler;
        protected final AtomicInteger size = new AtomicInteger(0);

        public RecycledProcessors(ConnectionHandler<?> handler) {
            this.handler = handler;
        }

        @Override
        public boolean push(Processor processor) {
            int cacheSize = this.handler.getProtocol().getProcessorCache();
            boolean offer = cacheSize == -1 ? true : this.size.get() < cacheSize;
            boolean result = false;
            if (offer && (result = super.push(processor))) {
                this.size.incrementAndGet();
            }
            if (!result) {
                this.handler.unregister(processor);
            }
            return result;
        }

        @Override
        public Processor pop() {
            Processor result = (Processor)super.pop();
            if (result != null) {
                this.size.decrementAndGet();
            }
            return result;
        }

        @Override
        public synchronized void clear() {
            Processor next = this.pop();
            while (next != null) {
                this.handler.unregister(next);
                next = this.pop();
            }
            super.clear();
            this.size.set(0);
        }
    }

    protected static class ConnectionHandler<S>
    implements AbstractEndpoint.Handler<S> {
        private final AbstractProtocol<S> proto;
        private final RequestGroupInfo global = new RequestGroupInfo();
        private final AtomicLong registerCount = new AtomicLong(0L);
        private final Map<S, Processor> connections = new ConcurrentHashMap<S, Processor>();
        private final RecycledProcessors recycledProcessors = new RecycledProcessors(this);

        public ConnectionHandler(AbstractProtocol<S> proto) {
            this.proto = proto;
        }

        protected AbstractProtocol<S> getProtocol() {
            return this.proto;
        }

        protected Log getLog() {
            return this.getProtocol().getLog();
        }

        @Override
        public Object getGlobal() {
            return this.global;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        @Override
        public AbstractProcessor getProcessor(SocketWrapperBase<S> socketWrapper) {
            Processor processor = this.connections.get(socketWrapper.getSocket());
            return processor == null ? null : (AbstractProcessor)processor;
        }

        public void releaseProcessor(SocketWrapperBase<S> socketWrapper) {
            Processor processor = this.connections.remove(socketWrapper.getSocket());
            this.release(processor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapperBase<S> wrapper, SocketEvent status) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug(sm.getString("abstractConnectionHandler.process", new Object[]{wrapper.getSocket(), status}));
            }
            if (wrapper == null) {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            S socket = wrapper.getSocket();
            Processor processor = this.connections.get(socket);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug(sm.getString("abstractConnectionHandler.connectionsGet", processor, socket));
            }
            if (SocketEvent.TIMEOUT == status && (processor == null || !processor.isAsync() && !processor.isUpgrade() || processor.isAsync() && !processor.checkAsyncTimeoutGeneration())) {
                return AbstractEndpoint.Handler.SocketState.OPEN;
            }
            if (processor != null) {
                this.getProtocol().removeWaitingProcessor(processor);
            } else if (status == SocketEvent.DISCONNECT || status == SocketEvent.ERROR) {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            ContainerThreadMarker.set();
            try {
                ClassLoader oldCL;
                UpgradeToken upgradeToken;
                String negotiatedProtocol;
                if (processor == null && (negotiatedProtocol = wrapper.getNegotiatedProtocol()) != null && negotiatedProtocol.length() > 0) {
                    UpgradeProtocol upgradeProtocol = this.getProtocol().getNegotiatedProtocol(negotiatedProtocol);
                    if (upgradeProtocol != null) {
                        processor = upgradeProtocol.getProcessor(wrapper, this.getProtocol().getAdapter());
                    } else if (!negotiatedProtocol.equals("http/1.1")) {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug(sm.getString("abstractConnectionHandler.negotiatedProcessor.fail", negotiatedProtocol));
                        }
                        AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
                        return socketState;
                    }
                }
                if (processor == null) {
                    processor = this.recycledProcessors.pop();
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug(sm.getString("abstractConnectionHandler.processorPop", processor));
                    }
                }
                if (processor == null) {
                    processor = this.getProtocol().createProcessor();
                    this.register(processor);
                }
                processor.setSslSupport(wrapper.getSslSupport(this.getProtocol().getClientCertProvider()));
                this.connections.put(socket, processor);
                AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
                do {
                    if ((state = processor.process(wrapper, status)) != AbstractEndpoint.Handler.SocketState.UPGRADING) continue;
                    upgradeToken = processor.getUpgradeToken();
                    ByteBuffer leftOverInput = processor.getLeftoverInput();
                    wrapper.unRead(leftOverInput);
                    if (upgradeToken == null) {
                        UpgradeProtocol upgradeProtocol = this.getProtocol().getUpgradeProtocol("h2c");
                        if (upgradeProtocol == null) {
                            if (this.getLog().isDebugEnabled()) {
                                this.getLog().debug(sm.getString("abstractConnectionHandler.negotiatedProcessor.fail", "h2c"));
                            }
                            AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
                            return socketState;
                        }
                        processor = upgradeProtocol.getProcessor(wrapper, this.getProtocol().getAdapter());
                        this.connections.put(socket, processor);
                        continue;
                    }
                    HttpUpgradeHandler httpUpgradeHandler = upgradeToken.getHttpUpgradeHandler();
                    this.release(processor);
                    processor = this.getProtocol().createUpgradeProcessor(wrapper, upgradeToken);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug(sm.getString("abstractConnectionHandler.upgradeCreate", processor, wrapper));
                    }
                    wrapper.setUpgraded(true);
                    this.connections.put(socket, processor);
                    if (upgradeToken.getInstanceManager() == null) {
                        httpUpgradeHandler.init((WebConnection)((Object)processor));
                        continue;
                    }
                    oldCL = upgradeToken.getContextBind().bind(false, null);
                    try {
                        httpUpgradeHandler.init((WebConnection)((Object)processor));
                    }
                    finally {
                        upgradeToken.getContextBind().unbind(false, oldCL);
                    }
                } while (state == AbstractEndpoint.Handler.SocketState.UPGRADING);
                if (state != AbstractEndpoint.Handler.SocketState.PARSED_HEADER) {
                    if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                        this.longPoll(wrapper, processor);
                        if (processor.isAsync()) {
                            this.getProtocol().addWaitingProcessor(processor);
                        }
                    } else if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                        this.connections.remove(socket);
                        this.release(processor);
                        wrapper.registerReadInterest();
                    } else if (state != AbstractEndpoint.Handler.SocketState.SENDFILE) {
                        if (state == AbstractEndpoint.Handler.SocketState.UPGRADED) {
                            if (status != SocketEvent.OPEN_WRITE) {
                                this.longPoll(wrapper, processor);
                                this.getProtocol().addWaitingProcessor(processor);
                            }
                        } else if (state != AbstractEndpoint.Handler.SocketState.SUSPENDED) {
                            this.connections.remove(socket);
                            if (processor.isUpgrade()) {
                                upgradeToken = processor.getUpgradeToken();
                                HttpUpgradeHandler httpUpgradeHandler = upgradeToken.getHttpUpgradeHandler();
                                InstanceManager instanceManager = upgradeToken.getInstanceManager();
                                if (instanceManager == null) {
                                    httpUpgradeHandler.destroy();
                                } else {
                                    oldCL = upgradeToken.getContextBind().bind(false, null);
                                    try {
                                        httpUpgradeHandler.destroy();
                                    }
                                    finally {
                                        try {
                                            instanceManager.destroyInstance(httpUpgradeHandler);
                                        }
                                        catch (Throwable e2) {
                                            ExceptionUtils.handleThrowable(e2);
                                            this.getLog().error(sm.getString("abstractConnectionHandler.error"), e2);
                                        }
                                        upgradeToken.getContextBind().unbind(false, oldCL);
                                    }
                                }
                            }
                            this.release(processor);
                        }
                    }
                }
                AbstractEndpoint.Handler.SocketState socketState = state;
                return socketState;
            }
            catch (SocketException e3) {
                this.getLog().debug(sm.getString("abstractConnectionHandler.socketexception.debug"), e3);
            }
            catch (IOException e4) {
                this.getLog().debug(sm.getString("abstractConnectionHandler.ioexception.debug"), e4);
            }
            catch (ProtocolException e5) {
                this.getLog().debug(sm.getString("abstractConnectionHandler.protocolexception.debug"), e5);
            }
            catch (OutOfMemoryError oome) {
                this.getLog().error(sm.getString("abstractConnectionHandler.oome"), oome);
            }
            catch (Throwable e6) {
                ExceptionUtils.handleThrowable(e6);
                this.getLog().error(sm.getString("abstractConnectionHandler.error"), e6);
            }
            finally {
                ContainerThreadMarker.clear();
            }
            this.connections.remove(socket);
            this.release(processor);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        protected void longPoll(SocketWrapperBase<?> socket, Processor processor) {
            if (!processor.isAsync()) {
                socket.registerReadInterest();
            }
        }

        @Override
        public Set<S> getOpenSockets() {
            return this.connections.keySet();
        }

        private void release(Processor processor) {
            if (processor != null) {
                processor.recycle();
                if (!processor.isUpgrade()) {
                    this.recycledProcessors.push(processor);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug("Pushed Processor [" + processor + "]");
                    }
                }
            }
        }

        @Override
        public void release(SocketWrapperBase<S> socketWrapper) {
            S socket = socketWrapper.getSocket();
            Processor processor = this.connections.remove(socket);
            this.release(processor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(Processor processor) {
            if (this.getProtocol().getDomain() != null) {
                ConnectionHandler connectionHandler = this;
                synchronized (connectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(this.global);
                        ObjectName rpName = new ObjectName(this.getProtocol().getDomain() + ":type=RequestProcessor,worker=" + this.getProtocol().getName() + ",name=" + this.getProtocol().getProtocolName() + "Request" + count);
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug("Register [" + processor + "] as [" + rpName + "]");
                        }
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e2) {
                        this.getLog().warn(sm.getString("abstractProtocol.processorRegisterError"), e2);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(Processor processor) {
            if (this.getProtocol().getDomain() != null) {
                ConnectionHandler connectionHandler = this;
                synchronized (connectionHandler) {
                    try {
                        Request r2 = processor.getRequest();
                        if (r2 == null) {
                            return;
                        }
                        RequestInfo rp = r2.getRequestProcessor();
                        rp.setGlobalProcessor(null);
                        ObjectName rpName = rp.getRpName();
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug("Unregister [" + rpName + "]");
                        }
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e2) {
                        this.getLog().warn(sm.getString("abstractProtocol.processorUnregisterError"), e2);
                    }
                }
            }
        }

        @Override
        public final void pause() {
            for (Processor processor : this.connections.values()) {
                processor.pause();
            }
        }
    }
}

