/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.crane.http11;

import com.bes.enterprise.web.crane.ActionCode;
import com.bes.enterprise.web.crane.Constants;
import com.bes.enterprise.web.crane.Response;
import com.bes.enterprise.web.crane.http11.HeadersTooLargeException;
import com.bes.enterprise.web.crane.http11.HttpOutputBuffer;
import com.bes.enterprise.web.crane.http11.OutputFilter;
import com.bes.enterprise.web.util.buf.ByteChunk;
import com.bes.enterprise.web.util.buf.MessageBytes;
import com.bes.enterprise.web.util.http.HttpMessages;
import com.bes.enterprise.web.util.net.SocketWrapperBase;
import com.bes.enterprise.web.util.res.StringManager;
import java.io.IOException;

public class Http11OutputBuffer
implements HttpOutputBuffer {
    protected static final StringManager sm = StringManager.getManager(Http11OutputBuffer.class);
    protected Response response;
    protected boolean responseFinished;
    protected final byte[] headerBuffer;
    protected int pos;
    protected OutputFilter[] filterLibrary;
    protected OutputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected HttpOutputBuffer outputStreamOutputBuffer;
    protected SocketWrapperBase<?> socketWrapper;
    protected long byteCount = 0L;
    @Deprecated
    private boolean sendReasonPhrase = false;

    protected Http11OutputBuffer(Response response, int headerBufferSize, boolean sendReasonPhrase) {
        this.response = response;
        this.sendReasonPhrase = sendReasonPhrase;
        this.headerBuffer = new byte[headerBufferSize];
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.responseFinished = false;
        this.outputStreamOutputBuffer = new SocketOutputBuffer();
        if (sendReasonPhrase) {
            HttpMessages.getInstance(response.getLocale()).getMessage(200);
        }
    }

    public void addFilter(OutputFilter filter) {
        OutputFilter[] newFilterLibrary = new OutputFilter[this.filterLibrary.length + 1];
        for (int i2 = 0; i2 < this.filterLibrary.length; ++i2) {
            newFilterLibrary[i2] = this.filterLibrary[i2];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new OutputFilter[this.filterLibrary.length];
    }

    public OutputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void addActiveFilter(OutputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.outputStreamOutputBuffer);
        } else {
            for (int i2 = 0; i2 <= this.lastActiveFilter; ++i2) {
                if (this.activeFilters[i2] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setResponse(this.response);
    }

    @Override
    public int doWrite(ByteChunk chunk) throws IOException {
        if (!this.response.isCommitted()) {
            this.response.action(ActionCode.COMMIT, null);
        }
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.doWrite(chunk);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(chunk);
    }

    @Override
    public long getBytesWritten() {
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.getBytesWritten();
        }
        return this.activeFilters[this.lastActiveFilter].getBytesWritten();
    }

    @Override
    public void flush() throws IOException {
        if (this.lastActiveFilter == -1) {
            this.outputStreamOutputBuffer.flush();
        } else {
            this.activeFilters[this.lastActiveFilter].flush();
        }
    }

    @Override
    public void end() throws IOException {
        if (this.responseFinished) {
            return;
        }
        if (this.lastActiveFilter == -1) {
            this.outputStreamOutputBuffer.end();
        } else {
            this.activeFilters[this.lastActiveFilter].end();
        }
        this.responseFinished = true;
    }

    void resetHeaderBuffer() {
        this.pos = 0;
    }

    public void recycle() {
        this.nextRequest();
        this.socketWrapper = null;
    }

    public void nextRequest() {
        for (int i2 = 0; i2 <= this.lastActiveFilter; ++i2) {
            this.activeFilters[i2].recycle();
        }
        this.response.recycle();
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.responseFinished = false;
        this.byteCount = 0L;
    }

    public void init(SocketWrapperBase<?> socketWrapper) {
        this.socketWrapper = socketWrapper;
    }

    public void sendAck() throws IOException {
        if (!this.response.isCommitted()) {
            if (this.sendReasonPhrase) {
                this.socketWrapper.write(this.isBlocking(), com.bes.enterprise.web.crane.http11.Constants.ACK_BYTES_REASON, 0, com.bes.enterprise.web.crane.http11.Constants.ACK_BYTES_REASON.length);
            } else {
                this.socketWrapper.write(this.isBlocking(), com.bes.enterprise.web.crane.http11.Constants.ACK_BYTES, 0, com.bes.enterprise.web.crane.http11.Constants.ACK_BYTES.length);
            }
            if (this.flushBuffer(true)) {
                throw new IOException(sm.getString("iob.failedwrite.ack"));
            }
        }
    }

    protected void commit() throws IOException {
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.socketWrapper.write(this.isBlocking(), this.headerBuffer, 0, this.pos);
        }
    }

    public void sendStatus() {
        this.write(com.bes.enterprise.web.crane.http11.Constants.HTTP_11_BYTES);
        this.headerBuffer[this.pos++] = 32;
        int status = this.response.getStatus();
        switch (status) {
            case 200: {
                this.write(com.bes.enterprise.web.crane.http11.Constants._200_BYTES);
                break;
            }
            case 400: {
                this.write(com.bes.enterprise.web.crane.http11.Constants._400_BYTES);
                break;
            }
            case 404: {
                this.write(com.bes.enterprise.web.crane.http11.Constants._404_BYTES);
                break;
            }
            default: {
                this.write(status);
            }
        }
        this.headerBuffer[this.pos++] = 32;
        if (this.sendReasonPhrase) {
            String message = null;
            if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER && HttpMessages.isSafeInHttpHeader(this.response.getMessage())) {
                message = this.response.getMessage();
            }
            if (message == null) {
                this.write(HttpMessages.getInstance(this.response.getLocale()).getMessage(status));
            } else {
                this.write(message);
            }
        }
        this.headerBuffer[this.pos++] = 13;
        this.headerBuffer[this.pos++] = 10;
    }

    public void sendHeader(MessageBytes name, MessageBytes value) {
        this.write(name);
        this.headerBuffer[this.pos++] = 58;
        this.headerBuffer[this.pos++] = 32;
        this.write(value);
        this.headerBuffer[this.pos++] = 13;
        this.headerBuffer[this.pos++] = 10;
    }

    public void endHeaders() {
        this.headerBuffer[this.pos++] = 13;
        this.headerBuffer[this.pos++] = 10;
    }

    private void write(MessageBytes mb) {
        if (mb.getType() != 2) {
            mb.toBytes();
            ByteChunk bc = mb.getByteChunk();
            byte[] buffer = bc.getBuffer();
            for (int i2 = bc.getOffset(); i2 < bc.getLength(); ++i2) {
                if ((buffer[i2] <= -1 || buffer[i2] > 31 || buffer[i2] == 9) && buffer[i2] != 127) continue;
                buffer[i2] = 32;
            }
        }
        this.write(mb.getByteChunk());
    }

    private void write(ByteChunk bc) {
        int length = bc.getLength();
        this.checkLengthBeforeWrite(length);
        System.arraycopy(bc.getBytes(), bc.getStart(), this.headerBuffer, this.pos, length);
        this.pos += length;
    }

    public void write(byte[] b2) {
        this.checkLengthBeforeWrite(b2.length);
        System.arraycopy(b2, 0, this.headerBuffer, this.pos, b2.length);
        this.pos += b2.length;
    }

    private void write(String s2) {
        if (s2 == null) {
            return;
        }
        int len = s2.length();
        this.checkLengthBeforeWrite(len);
        for (int i2 = 0; i2 < len; ++i2) {
            int c2 = s2.charAt(i2);
            if (c2 <= 31 && c2 != 9 || c2 == 127 || c2 > 255) {
                c2 = 32;
            }
            this.headerBuffer[this.pos++] = (byte)c2;
        }
    }

    private void write(int value) {
        String s2 = Integer.toString(value);
        int len = s2.length();
        this.checkLengthBeforeWrite(len);
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s2.charAt(i2);
            this.headerBuffer[this.pos++] = (byte)c2;
        }
    }

    private void checkLengthBeforeWrite(int length) {
        if (this.pos + length + 4 > this.headerBuffer.length) {
            throw new HeadersTooLargeException(sm.getString("iob.responseheadertoolarge.error"));
        }
    }

    protected boolean flushBuffer(boolean block) throws IOException {
        return this.socketWrapper.flush(block);
    }

    protected final boolean isBlocking() {
        return this.response.getWriteListener() == null;
    }

    protected final boolean isReady() {
        boolean result;
        boolean bl = result = !this.hasDataToWrite();
        if (!result) {
            this.socketWrapper.registerWriteInterest();
        }
        return result;
    }

    public boolean hasDataToWrite() {
        return this.socketWrapper.hasDataToWrite();
    }

    public void registerWriteInterest() {
        this.socketWrapper.registerWriteInterest();
    }

    boolean isChunking() {
        for (int i2 = 0; i2 < this.lastActiveFilter; ++i2) {
            if (this.activeFilters[i2] != this.filterLibrary[1]) continue;
            return true;
        }
        return false;
    }

    protected class SocketOutputBuffer
    implements HttpOutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        @Deprecated
        public int doWrite(ByteChunk chunk) throws IOException {
            try {
                int len = chunk.getLength();
                int start = chunk.getStart();
                byte[] b2 = chunk.getBuffer();
                Http11OutputBuffer.this.socketWrapper.write(Http11OutputBuffer.this.isBlocking(), b2, start, len);
                Http11OutputBuffer.this.byteCount += (long)len;
                return len;
            }
            catch (IOException ioe) {
                Http11OutputBuffer.this.response.action(ActionCode.CLOSE_NOW, ioe);
                throw ioe;
            }
        }

        @Override
        public long getBytesWritten() {
            return Http11OutputBuffer.this.byteCount;
        }

        @Override
        public void end() throws IOException {
            Http11OutputBuffer.this.socketWrapper.flush(true);
        }

        @Override
        public void flush() throws IOException {
            Http11OutputBuffer.this.socketWrapper.flush(Http11OutputBuffer.this.isBlocking());
        }
    }
}

