/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.crane.http11;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.crane.AbstractProcessor;
import com.bes.enterprise.web.crane.ActionCode;
import com.bes.enterprise.web.crane.ErrorState;
import com.bes.enterprise.web.crane.Request;
import com.bes.enterprise.web.crane.RequestInfo;
import com.bes.enterprise.web.crane.UpgradeProtocol;
import com.bes.enterprise.web.crane.UpgradeToken;
import com.bes.enterprise.web.crane.http11.AbstractHttp11Protocol;
import com.bes.enterprise.web.crane.http11.Constants;
import com.bes.enterprise.web.crane.http11.HeadersTooLargeException;
import com.bes.enterprise.web.crane.http11.Http11InputBuffer;
import com.bes.enterprise.web.crane.http11.Http11OutputBuffer;
import com.bes.enterprise.web.crane.http11.InputFilter;
import com.bes.enterprise.web.crane.http11.OutputFilter;
import com.bes.enterprise.web.crane.http11.filters.BufferedInputFilter;
import com.bes.enterprise.web.crane.http11.filters.ChunkedInputFilter;
import com.bes.enterprise.web.crane.http11.filters.ChunkedOutputFilter;
import com.bes.enterprise.web.crane.http11.filters.GzipOutputFilter;
import com.bes.enterprise.web.crane.http11.filters.IdentityInputFilter;
import com.bes.enterprise.web.crane.http11.filters.IdentityOutputFilter;
import com.bes.enterprise.web.crane.http11.filters.SavedRequestInputFilter;
import com.bes.enterprise.web.crane.http11.filters.VoidInputFilter;
import com.bes.enterprise.web.crane.http11.filters.VoidOutputFilter;
import com.bes.enterprise.web.crane.http11.upgrade.InternalHttpUpgradeHandler;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.buf.Ascii;
import com.bes.enterprise.web.util.buf.ByteChunk;
import com.bes.enterprise.web.util.buf.MessageBytes;
import com.bes.enterprise.web.util.buf.StringUtils;
import com.bes.enterprise.web.util.http.FastHttpDateFormat;
import com.bes.enterprise.web.util.http.MimeHeaders;
import com.bes.enterprise.web.util.http.parser.HttpParser;
import com.bes.enterprise.web.util.http.parser.TokenList;
import com.bes.enterprise.web.util.log.UserDataHelper;
import com.bes.enterprise.web.util.net.AbstractEndpoint;
import com.bes.enterprise.web.util.net.SendfileDataBase;
import com.bes.enterprise.web.util.net.SendfileKeepAliveState;
import com.bes.enterprise.web.util.net.SendfileState;
import com.bes.enterprise.web.util.net.SocketWrapperBase;
import com.bes.enterprise.web.util.res.StringManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.regex.Pattern;

public class Http11Processor
extends AbstractProcessor {
    private static final Log log = LogFactory.getLog(Http11Processor.class);
    private static final StringManager sm = StringManager.getManager(Http11Processor.class);
    private final AbstractHttp11Protocol<?> protocol;
    protected final Http11InputBuffer inputBuffer;
    protected final Http11OutputBuffer outputBuffer;
    private final HttpParser httpParser;
    private int pluggableFilterIndex = Integer.MAX_VALUE;
    protected volatile boolean keepAlive = true;
    protected boolean openSocket = false;
    protected boolean readComplete = true;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected Pattern restrictedUserAgents = null;
    protected int maxKeepAliveRequests = 1024;
    protected int connectionUploadTimeout = 300000;
    protected boolean disableUploadTimeout = false;
    protected int maxSavePostSize = 4096;
    protected UpgradeToken upgradeToken = null;
    protected SendfileDataBase sendfileData = null;
    public boolean haveParsedHeader = false;
    protected boolean parseHeadersBySelectorThread;

    public Http11Processor(AbstractHttp11Protocol<?> protocol, AbstractEndpoint<?> endpoint) {
        super(endpoint);
        this.protocol = protocol;
        this.httpParser = new HttpParser(protocol.getRelaxedPathChars(), protocol.getRelaxedQueryChars());
        this.inputBuffer = new Http11InputBuffer(this.request, protocol.getMaxHttpHeaderSize(), protocol.getRejectIllegalHeader(), this.httpParser);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new Http11OutputBuffer(this.response, protocol.getMaxHttpHeaderSize(), protocol.getSendReasonPhrase());
        this.response.setOutputBuffer(this.outputBuffer);
        this.inputBuffer.addFilter(new IdentityInputFilter(protocol.getMaxSwallowSize()));
        this.outputBuffer.addFilter(new IdentityOutputFilter());
        this.inputBuffer.addFilter(new ChunkedInputFilter(protocol.getMaxTrailerSize(), protocol.getAllowedTrailerHeadersInternal(), protocol.getMaxExtensionSize(), protocol.getMaxSwallowSize()));
        this.outputBuffer.addFilter(new ChunkedOutputFilter());
        this.inputBuffer.addFilter(new VoidInputFilter());
        this.outputBuffer.addFilter(new VoidOutputFilter());
        this.inputBuffer.addFilter(new BufferedInputFilter());
        this.outputBuffer.addFilter(new GzipOutputFilter());
        this.pluggableFilterIndex = this.inputBuffer.getFilters().length;
    }

    public boolean isParseHeadersBySelectorThread() {
        return this.parseHeadersBySelectorThread;
    }

    public void setParseHeadersBySelectorThread(boolean parseHeadersBySelectorThread) {
        this.parseHeadersBySelectorThread = parseHeadersBySelectorThread;
    }

    @Deprecated
    public void setCompression(String compression) {
        this.protocol.setCompression(compression);
    }

    @Deprecated
    public void setCompressionMinSize(int compressionMinSize) {
        this.protocol.setCompressionMinSize(compressionMinSize);
    }

    @Deprecated
    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.protocol.setNoCompressionUserAgents(noCompressionUserAgents);
    }

    @Deprecated
    public void setCompressibleMimeTypes(String[] compressibleMimeTypes) {
        this.protocol.setCompressibleMimeType(StringUtils.join(compressibleMimeTypes));
    }

    @Deprecated
    public String getCompression() {
        return this.protocol.getCompression();
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents == null || restrictedUserAgents.length() == 0 ? null : Pattern.compile(restrictedUserAgents);
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setMaxSavePostSize(int msps) {
        this.maxSavePostSize = msps;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setConnectionUploadTimeout(int timeout) {
        this.connectionUploadTimeout = timeout;
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    @Deprecated
    public void setServer(String server) {
        this.protocol.setServer(server);
    }

    @Deprecated
    public void setServerRemoveAppProvidedValues(boolean serverRemoveAppProvidedValues) {
        this.protocol.setServerRemoveAppProvidedValues(serverRemoveAppProvidedValues);
    }

    private static int findBytes(ByteChunk bc, byte[] b2) {
        byte first = b2[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b2.length;
        for (int i2 = start; i2 <= end - srcEnd; ++i2) {
            if (Ascii.toLower(buff[i2]) != first) continue;
            int myPos = i2 + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(buff[myPos++]) == b2[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i2 - start;
            }
        }
        return -1;
    }

    private static boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 500 || status == 503 || status == 501;
    }

    private void addInputFilter(InputFilter[] inputFilters, String encodingName) {
        if (!encodingName.equals("identity")) {
            if (encodingName.equals("chunked")) {
                this.inputBuffer.addActiveFilter(inputFilters[1]);
                this.contentDelimitation = true;
            } else {
                for (int i2 = this.pluggableFilterIndex; i2 < inputFilters.length; ++i2) {
                    if (!inputFilters[i2].getEncodingName().toString().equals(encodingName)) continue;
                    this.inputBuffer.addActiveFilter(inputFilters[i2]);
                    return;
                }
                this.response.setStatus(501);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("http11processor.request.prepare") + " Unsupported transfer encoding [" + encodingName + "]");
                }
            }
        }
    }

    @Override
    public AbstractEndpoint.Handler.SocketState service(SocketWrapperBase<?> socketWrapper) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(1);
        this.setSocketWrapper(socketWrapper);
        this.keepAlive = true;
        this.openSocket = false;
        this.readComplete = true;
        boolean keptAlive = false;
        SendfileState sendfileState = SendfileState.DONE;
        boolean diabledNextRequest = false;
        while (!(this.getErrorState().isError() || !this.keepAlive || this.isAsync() || this.upgradeToken != null || diabledNextRequest || sendfileState != SendfileState.DONE || this.endpoint.isPaused())) {
            String requestedProtocol;
            UpgradeProtocol upgradeProtocol;
            diabledNextRequest = this.parseHeadersBySelectorThread;
            if (this.parseHeadersBySelectorThread && this.haveParsedHeader) {
                this.haveParsedHeader = false;
            } else {
                try {
                    if (!this.inputBuffer.parseRequestLine(keptAlive, this.protocol.getConnectionTimeout(), this.protocol.getKeepAliveTimeout())) {
                        if (this.inputBuffer.getParsingRequestLinePhase() == -1) {
                            return AbstractEndpoint.Handler.SocketState.UPGRADING;
                        }
                        if (this.handleIncompleteRequestLineRead()) break;
                    }
                    if (this.endpoint.isPaused()) {
                        this.response.setStatus(503);
                        this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    } else {
                        keptAlive = true;
                        this.request.getMimeHeaders().setLimit(this.endpoint.getMaxHeaderCount());
                        if (!this.inputBuffer.parseHeaders()) {
                            this.openSocket = true;
                            this.readComplete = false;
                            break;
                        }
                        if (!this.disableUploadTimeout) {
                            socketWrapper.setReadTimeout(this.connectionUploadTimeout);
                        }
                        if (this.parseHeadersBySelectorThread) {
                            this.haveParsedHeader = true;
                            break;
                        }
                    }
                }
                catch (IOException e2) {
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("http11processor.header.parse"), e2);
                    }
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, e2);
                    break;
                }
                catch (Throwable t2) {
                    ExceptionUtils.handleThrowable(t2);
                    UserDataHelper.Mode logMode = this.userDataHelper.getNextMode();
                    if (logMode != null) {
                        String message = sm.getString("http11processor.header.parse");
                        switch (logMode) {
                            case INFO_THEN_DEBUG: {
                                message = message + sm.getString("http11processor.fallToDebug");
                            }
                            case INFO: {
                                log.info(message, t2);
                                break;
                            }
                            case DEBUG: {
                                log.debug(message, t2);
                            }
                        }
                    }
                    this.response.setStatus(400);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, t2);
                }
            }
            Enumeration<String> connectionValues = this.request.getMimeHeaders().values("Connection");
            boolean foundUpgrade = false;
            while (connectionValues.hasMoreElements() && !foundUpgrade) {
                String value = connectionValues.nextElement();
                if (value == null) continue;
                foundUpgrade = value.toLowerCase(Locale.ENGLISH).contains("upgrade");
            }
            if (foundUpgrade && (upgradeProtocol = this.protocol.getUpgradeProtocol(requestedProtocol = this.request.getHeader("Upgrade"))) != null && upgradeProtocol.accept(this.request)) {
                this.response.setStatus(101);
                this.response.setHeader("Connection", "Upgrade");
                this.response.setHeader("Upgrade", requestedProtocol);
                this.action(ActionCode.CLOSE, null);
                this.getAdapter().log(this.request, this.response, 0L);
                InternalHttpUpgradeHandler upgradeHandler = upgradeProtocol.getInternalUpgradeHandler(this.getAdapter(), this.cloneRequest(this.request));
                UpgradeToken upgradeToken = new UpgradeToken(upgradeHandler, null, null);
                this.action(ActionCode.UPGRADE, upgradeToken);
                return AbstractEndpoint.Handler.SocketState.UPGRADING;
            }
            if (this.getErrorState().isIoAllowed()) {
                rp.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable t3) {
                    ExceptionUtils.handleThrowable(t3);
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("http11processor.request.prepare"), t3);
                    }
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, t3);
                }
            }
            if (this.maxKeepAliveRequests == 1) {
                this.keepAlive = false;
            } else if (this.maxKeepAliveRequests > 0 && socketWrapper.decrementKeepAlive() <= 0) {
                this.keepAlive = false;
            }
            if (this.getErrorState().isIoAllowed()) {
                try {
                    rp.setStage(3);
                    this.getAdapter().service(this.request, this.response);
                    if (this.keepAlive && !this.getErrorState().isError() && !this.isAsync() && Http11Processor.statusDropsConnection(this.response.getStatus())) {
                        this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    }
                }
                catch (InterruptedIOException e3) {
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, e3);
                }
                catch (HeadersTooLargeException e4) {
                    log.error(sm.getString("http11processor.request.process"), e4);
                    if (this.response.isCommitted()) {
                        this.setErrorState(ErrorState.CLOSE_NOW, e4);
                    } else {
                        this.response.reset();
                        this.response.setStatus(500);
                        this.setErrorState(ErrorState.CLOSE_CLEAN, e4);
                        this.response.setHeader("Connection", "close");
                    }
                }
                catch (Throwable t4) {
                    ExceptionUtils.handleThrowable(t4);
                    log.error(sm.getString("http11processor.request.process"), t4);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, t4);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            rp.setStage(4);
            if (!this.isAsync()) {
                this.endRequest();
            }
            rp.setStage(5);
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
            }
            if (!this.isAsync() || this.getErrorState().isError()) {
                this.request.updateCounters();
                if (this.getErrorState().isIoAllowed()) {
                    this.inputBuffer.nextRequest();
                    this.outputBuffer.nextRequest();
                }
            }
            if (!this.disableUploadTimeout) {
                int soTimeout = this.endpoint.getConnectionTimeout();
                if (soTimeout > 0) {
                    socketWrapper.setReadTimeout(soTimeout);
                } else {
                    socketWrapper.setReadTimeout(0L);
                }
            }
            rp.setStage(6);
            sendfileState = this.processSendfile(socketWrapper);
        }
        rp.setStage(7);
        if (this.getErrorState().isError() || this.endpoint.isPaused()) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        if (this.isUpgrade()) {
            return AbstractEndpoint.Handler.SocketState.UPGRADING;
        }
        if (this.haveParsedHeader) {
            return AbstractEndpoint.Handler.SocketState.PARSED_HEADER;
        }
        if (sendfileState == SendfileState.PENDING) {
            return AbstractEndpoint.Handler.SocketState.SENDFILE;
        }
        if (this.openSocket) {
            if (this.readComplete) {
                return AbstractEndpoint.Handler.SocketState.OPEN;
            }
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    protected final void setSocketWrapper(SocketWrapperBase<?> socketWrapper) {
        super.setSocketWrapper(socketWrapper);
        this.inputBuffer.init(socketWrapper);
        this.outputBuffer.init(socketWrapper);
    }

    private Request cloneRequest(Request source) throws IOException {
        Request dest = new Request();
        dest.decodedURI().duplicate(source.decodedURI());
        dest.method().duplicate(source.method());
        dest.getMimeHeaders().duplicate(source.getMimeHeaders());
        dest.requestURI().duplicate(source.requestURI());
        dest.queryString().duplicate(source.queryString());
        return dest;
    }

    private boolean handleIncompleteRequestLineRead() {
        this.openSocket = true;
        if (this.inputBuffer.getParsingRequestLinePhase() > 1) {
            if (this.endpoint.isPaused()) {
                this.response.setStatus(503);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                return false;
            }
            this.readComplete = false;
        }
        return true;
    }

    private void checkExpectationAndResponseStatus() {
        if (this.request.hasExpectation() && (this.response.getStatus() < 200 || this.response.getStatus() > 299)) {
            this.inputBuffer.setSwallowInput(false);
            this.keepAlive = false;
        }
    }

    private void prepareRequest() throws IOException {
        MessageBytes transferEncodingValueMB;
        MessageBytes userAgentValueMB;
        MessageBytes expectMB;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        if (this.endpoint.isSSLEnabled()) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
            protocolMB.setString("HTTP/1.1");
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
            protocolMB.setString("HTTP/1.0");
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.response.setStatus(505);
            this.setErrorState(ErrorState.CLOSE_CLEAN, null);
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("http11processor.request.prepare") + " Unsupported HTTP version \"" + protocolMB + "\"");
            }
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("Connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (Http11Processor.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                this.keepAlive = false;
            } else if (Http11Processor.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                this.keepAlive = true;
            }
        }
        if (this.http11 && (expectMB = headers.getValue("expect")) != null && !expectMB.isNull()) {
            if (expectMB.toString().trim().equalsIgnoreCase("100-continue")) {
                this.inputBuffer.setSwallowInput(false);
                this.request.setExpectation(true);
            } else {
                this.response.setStatus(417);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
            }
        }
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive) && (userAgentValueMB = headers.getValue("user-agent")) != null && !userAgentValueMB.isNull()) {
            String userAgentValue = userAgentValueMB.toString();
            if (this.restrictedUserAgents != null && this.restrictedUserAgents.matcher(userAgentValue).matches()) {
                this.http11 = false;
                this.keepAlive = false;
            }
        }
        MessageBytes hostValueMB = null;
        try {
            hostValueMB = headers.getUniqueValue("host");
        }
        catch (IllegalArgumentException iae) {
            this.badRequest("http11processor.request.multipleHosts");
        }
        if (this.http11 && hostValueMB == null) {
            this.badRequest("http11processor.request.noHostHeader");
        }
        ByteChunk uriBC = this.request.requestURI().getByteChunk();
        byte[] uriB = uriBC.getBytes();
        if (uriBC.startsWithIgnoreCase("http", 0)) {
            int pos = 4;
            if (uriBC.startsWithIgnoreCase("s", pos)) {
                ++pos;
            }
            if (uriBC.startsWith("://", pos)) {
                int uriBCStart = uriBC.getStart();
                int slashPos = uriBC.indexOf('/', pos += 3);
                int atPos = uriBC.indexOf('@', pos);
                if (slashPos > -1 && atPos > slashPos) {
                    atPos = -1;
                }
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + 6, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                if (atPos != -1) {
                    while (pos < atPos) {
                        byte c2 = uriB[uriBCStart + pos];
                        if (!HttpParser.isUserInfo(c2)) {
                            this.badRequest("http11processor.request.invalidUserInfo");
                            break;
                        }
                        ++pos;
                    }
                    pos = atPos + 1;
                }
                if (this.http11) {
                    if (hostValueMB != null && !hostValueMB.getByteChunk().equals(uriB, uriBCStart + pos, slashPos - pos)) {
                        if (this.protocol.getAllowHostHeaderMismatch()) {
                            hostValueMB = headers.setValue("host");
                            hostValueMB.setBytes(uriB, uriBCStart + pos, slashPos - pos);
                        } else {
                            this.badRequest("http11processor.request.inconsistentHosts");
                        }
                    }
                } else {
                    try {
                        hostValueMB = headers.setValue("host");
                        hostValueMB.setBytes(uriB, uriBCStart + pos, slashPos - pos);
                    }
                    catch (IllegalStateException c2) {}
                }
            } else {
                this.badRequest("http11processor.request.invalidScheme");
            }
        }
        if (Http11InputBuffer.checkInvalidCharacterInURI) {
            for (int i2 = uriBC.getStart(); i2 < uriBC.getEnd(); ++i2) {
                if (this.httpParser.isAbsolutePathRelaxed(uriB[i2])) continue;
                this.badRequest("http11processor.request.invalidUri");
                break;
            }
        }
        InputFilter[] inputFilters = this.inputBuffer.getFilters();
        if (this.http11 && (transferEncodingValueMB = headers.getValue("transfer-encoding")) != null) {
            ArrayList<String> encodingNames = new ArrayList<String>();
            if (TokenList.parseTokenList(headers.values("transfer-encoding"), encodingNames)) {
                for (String encodingName : encodingNames) {
                    this.addInputFilter(inputFilters, encodingName);
                }
            } else {
                this.badRequest("http11processor.request.invalidTransferEncoding");
            }
        }
        long contentLength = -1L;
        try {
            contentLength = this.request.getContentLengthLong();
        }
        catch (NumberFormatException e2) {
            this.badRequest("http11processor.request.nonNumericContentLength");
        }
        catch (IllegalArgumentException e3) {
            this.badRequest("http11processor.request.multipleContentLength");
        }
        if (contentLength >= 0L) {
            if (this.contentDelimitation) {
                headers.removeHeader("content-length");
                this.request.setContentLength(-1L);
            } else {
                this.inputBuffer.addActiveFilter(inputFilters[0]);
                this.contentDelimitation = true;
            }
        }
        this.parseHost(hostValueMB);
        if (!this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
        if (!this.getErrorState().isIoAllowed()) {
            this.getAdapter().log(this.request, this.response, 0L);
        }
    }

    private void badRequest(String errorKey) {
        this.response.setStatus(400);
        this.setErrorState(ErrorState.CLOSE_CLEAN, null);
        if (log.isDebugEnabled()) {
            log.debug(sm.getString(errorKey));
        }
    }

    @Override
    protected final void prepareResponse() throws IOException {
        String server;
        MessageBytes methodMB;
        boolean entityBody = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilters = this.outputBuffer.getFilters();
        if (this.http09) {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            this.outputBuffer.commit();
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode < 200 || statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            entityBody = false;
            this.contentDelimitation = true;
            if (statusCode == 205) {
                this.response.setContentLength(0L);
            } else {
                this.response.setContentLength(-1L);
            }
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
        }
        if (this.endpoint.getUseSendfile()) {
            this.prepareSendfile(outputFilters);
        }
        boolean useCompression = false;
        if (entityBody && this.sendfileData == null) {
            useCompression = this.protocol.useCompression(this.request, this.response);
        }
        MimeHeaders headers = this.response.getMimeHeaders();
        if (entityBody || statusCode == 204) {
            String contentLanguage;
            String contentType = this.response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            }
            if ((contentLanguage = this.response.getContentLanguage()) != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        long contentLength = this.response.getContentLengthLong();
        boolean connectionClosePresent = false;
        if (contentLength != -1L) {
            headers.setValue("Content-Length").setLong(contentLength);
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            this.contentDelimitation = true;
        } else {
            connectionClosePresent = Http11Processor.isConnectionClose(headers);
            if (this.http11 && entityBody && !connectionClosePresent) {
                this.outputBuffer.addActiveFilter(outputFilters[1]);
                this.contentDelimitation = true;
                headers.addValue("Transfer-Encoding").setString("chunked");
            } else {
                this.outputBuffer.addActiveFilter(outputFilters[0]);
            }
        }
        if (useCompression) {
            this.outputBuffer.addActiveFilter(outputFilters[3]);
        }
        if (headers.getValue("Date") == null) {
            headers.addValue("Date").setString(FastHttpDateFormat.getCurrentDate());
        }
        if (entityBody && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        this.checkExpectationAndResponseStatus();
        if (this.keepAlive && Http11Processor.statusDropsConnection(statusCode)) {
            this.keepAlive = false;
        }
        if (!this.keepAlive) {
            if (!connectionClosePresent) {
                headers.addValue("Connection").setString("close");
            }
        } else if (!this.getErrorState().isError()) {
            int keepAliveTimeout;
            boolean connectionKeepAlivePresent;
            if (!this.http11) {
                headers.addValue("Connection").setString("keep-alive");
            }
            if (this.protocol.getUseKeepAliveResponseHeader() && (connectionKeepAlivePresent = Http11Processor.isConnectionKeepAlive(this.request.getMimeHeaders())) && (keepAliveTimeout = this.protocol.getKeepAliveTimeout()) > 0) {
                String value = "timeout=" + (long)keepAliveTimeout / 1000L;
                headers.setValue("Keep-Alive").setString(value);
                if (this.http11) {
                    MessageBytes connectionHeaderValue = headers.getValue("Connection");
                    if (connectionHeaderValue == null) {
                        headers.addValue("Connection").setString("keep-alive");
                    } else {
                        connectionHeaderValue.setString(connectionHeaderValue.getString() + ", " + "keep-alive");
                    }
                }
            }
        }
        if ((server = this.protocol.getServer()) == null) {
            if (this.protocol.getServerRemoveAppProvidedValues()) {
                headers.removeHeader("server");
            }
        } else {
            headers.setValue("Server").setString(server);
        }
        try {
            this.outputBuffer.sendStatus();
            int size = headers.size();
            for (int i2 = 0; i2 < size; ++i2) {
                this.outputBuffer.sendHeader(headers.getName(i2), headers.getValue(i2));
            }
            this.outputBuffer.endHeaders();
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            this.outputBuffer.resetHeaderBuffer();
            throw t2;
        }
        this.outputBuffer.commit();
    }

    private static boolean isConnectionClose(MimeHeaders headers) {
        MessageBytes connection = headers.getValue("Connection");
        if (connection == null) {
            return false;
        }
        return connection.equalsIgnoreCase("close");
    }

    private static boolean isConnectionKeepAlive(MimeHeaders headers) {
        MessageBytes connection = headers.getValue("Connection");
        if (connection == null) {
            return false;
        }
        return connection.equalsIgnoreCase("keep-alive");
    }

    private void prepareSendfile(OutputFilter[] outputFilters) {
        String fileName = (String)this.request.getAttribute("com.bes.enterprise.web.sendfile.filename");
        if (fileName == null) {
            this.sendfileData = null;
        } else {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
            long pos = (Long)this.request.getAttribute("com.bes.enterprise.web.sendfile.start");
            long end = (Long)this.request.getAttribute("com.bes.enterprise.web.sendfile.end");
            this.sendfileData = this.socketWrapper.createSendfileData(fileName, pos, end - pos);
        }
    }

    @Override
    protected void populatePort() {
        this.request.action(ActionCode.REQ_LOCALPORT_ATTRIBUTE, this.request);
        this.request.setServerPort(this.request.getLocalPort());
    }

    @Override
    protected boolean flushBufferedWrite() throws IOException {
        if (this.outputBuffer.hasDataToWrite() && this.outputBuffer.flushBuffer(false)) {
            this.outputBuffer.registerWriteInterest();
            return true;
        }
        return false;
    }

    @Override
    protected AbstractEndpoint.Handler.SocketState dispatchEndRequest() {
        if (!this.keepAlive) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        this.endRequest();
        this.inputBuffer.nextRequest();
        this.outputBuffer.nextRequest();
        if (this.socketWrapper.isReadPending()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private void endRequest() {
        if (this.getErrorState().isError()) {
            this.inputBuffer.setSwallowInput(false);
        } else {
            this.checkExpectationAndResponseStatus();
        }
        if (this.getErrorState().isIoAllowed()) {
            try {
                this.inputBuffer.endRequest();
            }
            catch (IOException e2) {
                this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, e2);
            }
            catch (Throwable t2) {
                ExceptionUtils.handleThrowable(t2);
                this.response.setStatus(500);
                this.setErrorState(ErrorState.CLOSE_NOW, t2);
                log.error(sm.getString("http11processor.request.finish"), t2);
            }
        }
        if (this.getErrorState().isIoAllowed()) {
            try {
                this.action(ActionCode.COMMIT, null);
                this.outputBuffer.end();
            }
            catch (IOException e3) {
                this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, e3);
            }
            catch (Throwable t3) {
                ExceptionUtils.handleThrowable(t3);
                this.setErrorState(ErrorState.CLOSE_NOW, t3);
                log.error(sm.getString("http11processor.response.finish"), t3);
            }
        }
    }

    @Override
    protected final void finishResponse() throws IOException {
        this.outputBuffer.end();
    }

    @Override
    protected final void ack() {
        if (!this.response.isCommitted() && this.request.hasExpectation()) {
            this.inputBuffer.setSwallowInput(true);
            try {
                this.outputBuffer.sendAck();
            }
            catch (IOException e2) {
                this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, e2);
            }
        }
    }

    @Override
    protected final void flush() throws IOException {
        this.outputBuffer.flush();
    }

    @Override
    protected final int available(boolean doRead) {
        return this.inputBuffer.available(doRead);
    }

    @Override
    protected final void setRequestBody(ByteChunk body) {
        SavedRequestInputFilter savedBody = new SavedRequestInputFilter(body);
        Http11InputBuffer internalBuffer = (Http11InputBuffer)this.request.getInputBuffer();
        internalBuffer.addActiveFilter(savedBody);
    }

    @Override
    protected final void setSwallowResponse() {
        this.outputBuffer.responseFinished = true;
    }

    @Override
    protected final void disableSwallowRequest() {
        this.inputBuffer.setSwallowInput(false);
    }

    @Override
    protected final void sslReHandShake() throws IOException {
        if (this.sslSupport != null) {
            InputFilter[] inputFilters = this.inputBuffer.getFilters();
            ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
            this.inputBuffer.addActiveFilter(inputFilters[3]);
            this.socketWrapper.doClientAuth(this.sslSupport);
            try {
                X509Certificate[] sslO = this.sslSupport.getPeerCertificateChain();
                if (sslO != null) {
                    this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                }
            }
            catch (IOException ioe) {
                log.warn(sm.getString("http11processor.socket.ssl"), ioe);
            }
        }
    }

    @Override
    protected final boolean isRequestBodyFullyRead() {
        return this.inputBuffer.isFinished();
    }

    @Override
    protected final void registerReadInterest() {
        this.socketWrapper.registerReadInterest();
    }

    @Override
    protected final boolean isReadyForWrite() {
        return this.outputBuffer.isReady();
    }

    @Override
    public UpgradeToken getUpgradeToken() {
        return this.upgradeToken;
    }

    @Override
    protected final void doHttpUpgrade(UpgradeToken upgradeToken) {
        this.upgradeToken = upgradeToken;
        this.outputBuffer.responseFinished = true;
    }

    @Override
    public ByteBuffer getLeftoverInput() {
        return this.inputBuffer.getLeftover();
    }

    @Override
    public boolean isUpgrade() {
        return this.upgradeToken != null;
    }

    @Override
    protected boolean isTrailerFieldsReady() {
        if (this.inputBuffer.isChunking()) {
            return this.inputBuffer.isFinished();
        }
        return true;
    }

    @Override
    protected boolean isTrailerFieldsSupported() {
        if (!this.http11) {
            return false;
        }
        if (!this.response.isCommitted()) {
            return true;
        }
        return this.outputBuffer.isChunking();
    }

    private SendfileState processSendfile(SocketWrapperBase<?> socketWrapper) {
        this.openSocket = this.keepAlive;
        SendfileState result = SendfileState.DONE;
        if (this.sendfileData != null && !this.getErrorState().isError()) {
            this.sendfileData.keepAliveState = this.keepAlive ? (this.available(false) == 0 ? SendfileKeepAliveState.OPEN : SendfileKeepAliveState.PIPELINED) : SendfileKeepAliveState.NONE;
            result = socketWrapper.processSendfile(this.sendfileData);
            switch (result) {
                case ERROR: {
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("http11processor.sendfile.error"));
                    }
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, null);
                }
            }
            this.sendfileData = null;
        }
        return result;
    }

    @Override
    public final void recycle() {
        this.getAdapter().checkRecycled(this.request, this.response);
        super.recycle();
        this.inputBuffer.recycle();
        this.outputBuffer.recycle();
        this.upgradeToken = null;
        this.socketWrapper = null;
        this.sendfileData = null;
        this.haveParsedHeader = false;
    }

    @Override
    public void pause() {
    }
}

