/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.crane.http11.filters;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.crane.Response;
import com.bes.enterprise.web.crane.http11.HttpOutputBuffer;
import com.bes.enterprise.web.crane.http11.OutputFilter;
import com.bes.enterprise.web.util.buf.ByteChunk;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class GzipOutputFilter
implements OutputFilter {
    protected static final Log log = LogFactory.getLog(GzipOutputFilter.class);
    protected HttpOutputBuffer buffer;
    protected GZIPOutputStream compressionStream = null;
    protected final OutputStream fakeOutputStream = new FakeOutputStream();

    @Override
    public int doWrite(ByteChunk chunk) throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = new GZIPOutputStream(this.fakeOutputStream, true);
        }
        this.compressionStream.write(chunk.getBytes(), chunk.getStart(), chunk.getLength());
        return chunk.getLength();
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    @Override
    public void flush() throws IOException {
        block4: {
            if (this.compressionStream != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Flushing the compression stream!");
                    }
                    this.compressionStream.flush();
                }
                catch (IOException e2) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Ignored exception while flushing gzip filter", e2);
                }
            }
        }
        this.buffer.flush();
    }

    @Override
    public void setResponse(Response response) {
    }

    @Override
    public void setBuffer(HttpOutputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void end() throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = new GZIPOutputStream(this.fakeOutputStream, true);
        }
        this.compressionStream.finish();
        this.compressionStream.close();
        this.buffer.end();
    }

    @Override
    public void recycle() {
        this.compressionStream = null;
    }

    protected class FakeOutputStream
    extends OutputStream {
        protected final ByteChunk outputChunk = new ByteChunk();
        protected final byte[] singleByteBuffer = new byte[1];

        protected FakeOutputStream() {
        }

        @Override
        public void write(int b2) throws IOException {
            this.singleByteBuffer[0] = (byte)(b2 & 0xFF);
            this.outputChunk.setBytes(this.singleByteBuffer, 0, 1);
            GzipOutputFilter.this.buffer.doWrite(this.outputChunk);
        }

        @Override
        public void write(byte[] b2, int off, int len) throws IOException {
            this.outputChunk.setBytes(b2, off, len);
            GzipOutputFilter.this.buffer.doWrite(this.outputChunk);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

