/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.crane.http11.filters;

import com.bes.enterprise.web.crane.Response;
import com.bes.enterprise.web.crane.http11.HttpOutputBuffer;
import com.bes.enterprise.web.crane.http11.OutputFilter;
import com.bes.enterprise.web.util.buf.ByteChunk;
import java.io.IOException;

public class IdentityOutputFilter
implements OutputFilter {
    protected long contentLength = -1L;
    protected long remaining = 0L;
    protected HttpOutputBuffer buffer;

    @Override
    public int doWrite(ByteChunk chunk) throws IOException {
        int result = -1;
        if (this.contentLength >= 0L) {
            if (this.remaining > 0L) {
                result = chunk.getLength();
                if ((long)result > this.remaining) {
                    chunk.setBytes(chunk.getBytes(), chunk.getStart(), (int)this.remaining);
                    result = (int)this.remaining;
                    this.remaining = 0L;
                } else {
                    this.remaining -= (long)result;
                }
                this.buffer.doWrite(chunk);
            } else {
                chunk.recycle();
                result = -1;
            }
        } else {
            this.buffer.doWrite(chunk);
            result = chunk.getLength();
        }
        return result;
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    @Override
    public void setResponse(Response response) {
        this.remaining = this.contentLength = response.getContentLengthLong();
    }

    @Override
    public void setBuffer(HttpOutputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void end() throws IOException {
        this.buffer.end();
    }

    @Override
    public void recycle() {
        this.contentLength = -1L;
        this.remaining = 0L;
    }
}

