/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.crane.http11.filters;

import com.bes.enterprise.web.crane.InputBuffer;
import com.bes.enterprise.web.crane.Request;
import com.bes.enterprise.web.crane.http11.InputFilter;
import com.bes.enterprise.web.util.buf.ByteChunk;
import java.io.IOException;

public class SavedRequestInputFilter
implements InputFilter {
    protected ByteChunk input = null;

    public SavedRequestInputFilter(ByteChunk input) {
        this.input = input;
    }

    @Override
    public int doRead(ByteChunk chunk) throws IOException {
        if (this.input.getOffset() >= this.input.getEnd()) {
            return -1;
        }
        int writeLength = 0;
        writeLength = chunk.getLimit() > 0 && chunk.getLimit() < this.input.getLength() ? chunk.getLimit() : this.input.getLength();
        this.input.substract(chunk.getBuffer(), 0, writeLength);
        chunk.setOffset(0);
        chunk.setEnd(writeLength);
        return writeLength;
    }

    @Override
    public void setRequest(Request request) {
        request.setContentLength(this.input.getLength());
    }

    @Override
    public void recycle() {
        this.input = null;
    }

    @Override
    public ByteChunk getEncodingName() {
        return null;
    }

    @Override
    public void setBuffer(InputBuffer buffer) {
    }

    @Override
    public int available() {
        return this.input.getLength();
    }

    @Override
    public long end() throws IOException {
        return 0L;
    }

    @Override
    public boolean isFinished() {
        return this.input.getOffset() >= this.input.getEnd();
    }
}

