/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.crane.http2;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.crane.AbstractProcessor;
import com.bes.enterprise.web.crane.ActionCode;
import com.bes.enterprise.web.crane.Adapter;
import com.bes.enterprise.web.crane.ContainerThreadMarker;
import com.bes.enterprise.web.crane.ErrorState;
import com.bes.enterprise.web.crane.Request;
import com.bes.enterprise.web.crane.Response;
import com.bes.enterprise.web.crane.http11.filters.GzipOutputFilter;
import com.bes.enterprise.web.crane.http2.ConnectionException;
import com.bes.enterprise.web.crane.http2.Http2Error;
import com.bes.enterprise.web.crane.http2.Http2Protocol;
import com.bes.enterprise.web.crane.http2.Http2UpgradeHandler;
import com.bes.enterprise.web.crane.http2.Stream;
import com.bes.enterprise.web.crane.http2.StreamException;
import com.bes.enterprise.web.util.buf.ByteChunk;
import com.bes.enterprise.web.util.http.FastHttpDateFormat;
import com.bes.enterprise.web.util.http.MimeHeaders;
import com.bes.enterprise.web.util.net.AbstractEndpoint;
import com.bes.enterprise.web.util.net.DispatchType;
import com.bes.enterprise.web.util.net.SocketEvent;
import com.bes.enterprise.web.util.net.SocketWrapperBase;
import com.bes.enterprise.web.util.res.StringManager;
import java.io.IOException;
import java.util.Iterator;

class StreamProcessor
extends AbstractProcessor {
    private static final Log log = LogFactory.getLog(StreamProcessor.class);
    private static final StringManager sm = StringManager.getManager(StreamProcessor.class);
    private final Http2UpgradeHandler handler;
    private final Stream stream;

    StreamProcessor(Http2UpgradeHandler handler, Stream stream, Adapter adapter, SocketWrapperBase<?> socketWrapper) {
        super(socketWrapper.getEndpoint(), stream.getCoyoteRequest(), stream.getCoyoteResponse());
        this.handler = handler;
        this.stream = stream;
        this.setAdapter(adapter);
        this.setSocketWrapper(socketWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void process(SocketEvent event) {
        try {
            StreamProcessor streamProcessor = this;
            synchronized (streamProcessor) {
                ContainerThreadMarker.set();
                AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
                try {
                    state = this.process(this.socketWrapper, event);
                    if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                        this.handler.getProtocol().getHttp11Protocol().addWaitingProcessor(this);
                    }
                    if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        if (!this.getErrorState().isConnectionIoAllowed()) {
                            ConnectionException ce = new ConnectionException(sm.getString("streamProcessor.error.connection", this.stream.getConnectionId(), this.stream.getIdentifier()), Http2Error.INTERNAL_ERROR);
                            this.stream.close(ce);
                        } else if (!this.getErrorState().isIoAllowed()) {
                            StreamException se = this.stream.getResetException();
                            if (se == null) {
                                se = new StreamException(sm.getString("streamProcessor.error.stream", this.stream.getConnectionId(), this.stream.getIdentifier()), Http2Error.INTERNAL_ERROR, this.stream.getIdAsInt());
                            }
                            this.stream.close(se);
                        } else if (!this.stream.isActive()) {
                            this.stream.recycle();
                        }
                    }
                }
                catch (Exception e2) {
                    String msg = sm.getString("streamProcessor.error.connection", this.stream.getConnectionId(), this.stream.getIdentifier());
                    if (log.isDebugEnabled()) {
                        log.debug(msg, e2);
                    }
                    ConnectionException ce = new ConnectionException(msg, Http2Error.INTERNAL_ERROR);
                    ce.initCause(e2);
                    this.stream.close(ce);
                }
                finally {
                    ContainerThreadMarker.clear();
                }
            }
        }
        finally {
            this.handler.executeQueuedStream();
        }
    }

    @Override
    protected final void prepareResponse() throws IOException {
        this.response.setCommitted(true);
        StreamProcessor.prepareHeaders(this.request, this.response, this.handler.getProtocol(), this.stream);
        this.stream.writeHeaders();
    }

    static void prepareHeaders(Request coyoteRequest, Response coyoteResponse, Http2Protocol protocol, Stream stream) {
        MimeHeaders headers = coyoteResponse.getMimeHeaders();
        int statusCode = coyoteResponse.getStatus();
        headers.addValue(":status").setString(Integer.toString(statusCode));
        if (statusCode >= 200 && statusCode != 204 && statusCode != 205 && statusCode != 304) {
            long contentLength;
            String contentLanguage;
            String contentType = coyoteResponse.getContentType();
            if (contentType != null) {
                headers.setValue("content-type").setString(contentType);
            }
            if ((contentLanguage = coyoteResponse.getContentLanguage()) != null) {
                headers.setValue("content-language").setString(contentLanguage);
            }
            if ((contentLength = coyoteResponse.getContentLengthLong()) != -1L && headers.getValue("content-length") == null) {
                headers.addValue("content-length").setLong(contentLength);
            }
        } else if (statusCode == 205) {
            coyoteResponse.setContentLength(0L);
        } else {
            coyoteResponse.setContentLength(-1L);
        }
        if (statusCode >= 200 && headers.getValue("date") == null) {
            headers.addValue("date").setString(FastHttpDateFormat.getCurrentDate());
        }
        if (protocol != null && protocol.useCompression(coyoteRequest, coyoteResponse)) {
            stream.addOutputFilter(new GzipOutputFilter());
        }
    }

    @Override
    protected final void finishResponse() throws IOException {
        this.stream.getOutputBuffer().end();
    }

    @Override
    protected final void ack() {
        if (!this.response.isCommitted() && this.request.hasExpectation()) {
            try {
                this.stream.writeAck();
            }
            catch (IOException ioe) {
                this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, ioe);
            }
        }
    }

    @Override
    protected final void flush() throws IOException {
        this.stream.getOutputBuffer().flush();
    }

    @Override
    protected final int available(boolean doRead) {
        return this.stream.getInputBuffer().available();
    }

    @Override
    protected final void setRequestBody(ByteChunk body) {
        this.stream.getInputBuffer().insertReplayedBody(body);
        try {
            this.stream.receivedEndOfStream();
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    @Override
    protected final void setSwallowResponse() {
    }

    @Override
    protected final void disableSwallowRequest() {
    }

    @Override
    protected void processSocketEvent(SocketEvent event, boolean dispatch) {
        if (dispatch) {
            this.handler.processStreamOnContainerThread(this, event);
        } else {
            this.process(event);
        }
    }

    @Override
    protected final boolean isReadyForRead() {
        return this.stream.getInputBuffer().isReadyForRead();
    }

    @Override
    protected final boolean isRequestBodyFullyRead() {
        return this.stream.getInputBuffer().isRequestBodyFullyRead();
    }

    @Override
    protected final void registerReadInterest() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final boolean isReadyForWrite() {
        return this.stream.isReadyForWrite();
    }

    @Override
    protected final void executeDispatches() {
        Iterator<DispatchType> dispatches = this.getIteratorAndClearDispatches();
        while (dispatches != null && dispatches.hasNext()) {
            DispatchType dispatchType = dispatches.next();
            this.processSocketEvent(dispatchType.getSocketStatus(), true);
        }
    }

    @Override
    protected final boolean isPushSupported() {
        return this.stream.isPushSupported();
    }

    @Override
    protected final void doPush(Request pushTarget) {
        try {
            this.stream.push(pushTarget);
        }
        catch (IOException ioe) {
            this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, ioe);
            this.response.setErrorException(ioe);
        }
    }

    @Override
    protected boolean isTrailerFieldsReady() {
        return this.stream.isTrailerFieldsReady();
    }

    @Override
    protected boolean isTrailerFieldsSupported() {
        return this.stream.isTrailerFieldsSupported();
    }

    @Override
    public void recycle() {
        this.setSocketWrapper(null);
        this.setAdapter(null);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public void pause() {
    }

    @Override
    public AbstractEndpoint.Handler.SocketState service(SocketWrapperBase<?> socket) throws IOException {
        try {
            this.adapter.service(this.request, this.response);
        }
        catch (Exception e2) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("streamProcessor.service.error"), e2);
            }
            this.response.setStatus(500);
            this.setErrorState(ErrorState.CLOSE_NOW, e2);
        }
        if (!this.isAsync()) {
            this.endRequest();
        }
        if (this.getErrorState().isError()) {
            this.action(ActionCode.CLOSE, null);
            this.request.updateCounters();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.action(ActionCode.CLOSE, null);
        this.request.updateCounters();
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    protected boolean flushBufferedWrite() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("streamProcessor.flushBufferedWrite.entry", this.stream.getConnectionId(), this.stream.getIdentifier()));
        }
        if (this.stream.flush(false)) {
            if (this.stream.isReadyForWrite()) {
                throw new IllegalStateException();
            }
            return true;
        }
        return false;
    }

    @Override
    protected final AbstractEndpoint.Handler.SocketState dispatchEndRequest() throws IOException {
        this.endRequest();
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    private void endRequest() throws IOException {
        if (!this.stream.isInputFinished() && this.getErrorState().isIoAllowed()) {
            StreamException se = new StreamException(sm.getString("streamProcessor.cancel", this.stream.getConnectionId(), this.stream.getIdentifier()), Http2Error.CANCEL, this.stream.getIdAsInt());
            this.handler.sendStreamReset(se);
        }
    }
}

