/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.jasper.compiler;

import com.bes.enterprise.web.jasper.JasperException;
import com.bes.enterprise.web.jasper.compiler.Compiler;
import com.bes.enterprise.web.jasper.compiler.Node;
import com.bes.enterprise.web.jasper.compiler.PageInfo;

class Collector {
    Collector() {
    }

    public static void collect(Compiler compiler, Node.Nodes page) throws JasperException {
        CollectVisitor collectVisitor = new CollectVisitor();
        page.visit(collectVisitor);
        collectVisitor.updatePageInfo(compiler.getPageInfo());
    }

    private static class CollectVisitor
    extends Node.Visitor {
        private boolean scriptingElementSeen = false;
        private boolean usebeanSeen = false;
        private boolean includeActionSeen = false;
        private boolean paramActionSeen = false;
        private boolean setPropertySeen = false;
        private boolean hasScriptingVars = false;

        private CollectVisitor() {
        }

        @Override
        public void visit(Node.ParamAction n2) throws JasperException {
            if (n2.getValue().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.paramActionSeen = true;
        }

        @Override
        public void visit(Node.IncludeAction n2) throws JasperException {
            if (n2.getPage().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.includeActionSeen = true;
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.ForwardAction n2) throws JasperException {
            if (n2.getPage().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.SetProperty n2) throws JasperException {
            if (n2.getValue() != null && n2.getValue().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.setPropertySeen = true;
        }

        @Override
        public void visit(Node.UseBean n2) throws JasperException {
            if (n2.getBeanName() != null && n2.getBeanName().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.usebeanSeen = true;
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.PlugIn n2) throws JasperException {
            if (n2.getHeight() != null && n2.getHeight().isExpression()) {
                this.scriptingElementSeen = true;
            }
            if (n2.getWidth() != null && n2.getWidth().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.CustomTag n2) throws JasperException {
            this.checkSeen(n2.getChildInfo(), n2);
        }

        private void checkSeen(Node.ChildInfo ci, Node n2) throws JasperException {
            Node.CustomTag ct;
            boolean scriptingElementSeenSave = this.scriptingElementSeen;
            this.scriptingElementSeen = false;
            boolean usebeanSeenSave = this.usebeanSeen;
            this.usebeanSeen = false;
            boolean includeActionSeenSave = this.includeActionSeen;
            this.includeActionSeen = false;
            boolean paramActionSeenSave = this.paramActionSeen;
            this.paramActionSeen = false;
            boolean setPropertySeenSave = this.setPropertySeen;
            this.setPropertySeen = false;
            boolean hasScriptingVarsSave = this.hasScriptingVars;
            this.hasScriptingVars = false;
            if (n2 instanceof Node.CustomTag) {
                ct = (Node.CustomTag)n2;
                Node.JspAttribute[] attrs = ct.getJspAttributes();
                for (int i2 = 0; attrs != null && i2 < attrs.length; ++i2) {
                    if (!attrs[i2].isExpression()) continue;
                    this.scriptingElementSeen = true;
                    break;
                }
            }
            this.visitBody(n2);
            if (n2 instanceof Node.CustomTag && !this.hasScriptingVars) {
                ct = (Node.CustomTag)n2;
                this.hasScriptingVars = ct.getVariableInfos().length > 0 || ct.getTagVariableInfos().length > 0;
            }
            ci.setScriptless(!this.scriptingElementSeen);
            ci.setHasUseBean(this.usebeanSeen);
            ci.setHasIncludeAction(this.includeActionSeen);
            ci.setHasParamAction(this.paramActionSeen);
            ci.setHasSetProperty(this.setPropertySeen);
            ci.setHasScriptingVars(this.hasScriptingVars);
            this.scriptingElementSeen = this.scriptingElementSeen || scriptingElementSeenSave;
            this.usebeanSeen = this.usebeanSeen || usebeanSeenSave;
            this.setPropertySeen = this.setPropertySeen || setPropertySeenSave;
            this.includeActionSeen = this.includeActionSeen || includeActionSeenSave;
            this.paramActionSeen = this.paramActionSeen || paramActionSeenSave;
            this.hasScriptingVars = this.hasScriptingVars || hasScriptingVarsSave;
        }

        @Override
        public void visit(Node.JspElement n2) throws JasperException {
            if (n2.getNameAttribute().isExpression()) {
                this.scriptingElementSeen = true;
            }
            Node.JspAttribute[] attrs = n2.getJspAttributes();
            for (int i2 = 0; i2 < attrs.length; ++i2) {
                if (!attrs[i2].isExpression()) continue;
                this.scriptingElementSeen = true;
                break;
            }
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.JspBody n2) throws JasperException {
            this.checkSeen(n2.getChildInfo(), n2);
        }

        @Override
        public void visit(Node.NamedAttribute n2) throws JasperException {
            this.checkSeen(n2.getChildInfo(), n2);
        }

        @Override
        public void visit(Node.Declaration n2) throws JasperException {
            this.scriptingElementSeen = true;
        }

        @Override
        public void visit(Node.Expression n2) throws JasperException {
            this.scriptingElementSeen = true;
        }

        @Override
        public void visit(Node.Scriptlet n2) throws JasperException {
            this.scriptingElementSeen = true;
        }

        private void updatePageInfo(PageInfo pageInfo) {
            pageInfo.setScriptless(!this.scriptingElementSeen);
        }
    }
}

